/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.prestosql.orc.checkpoint.BooleanStreamCheckpoint;
import io.prestosql.orc.checkpoint.ByteArrayStreamCheckpoint;
import io.prestosql.orc.checkpoint.LongStreamCheckpoint;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.CompressedMetadataWriter;
import io.prestosql.orc.metadata.CompressionKind;
import io.prestosql.orc.metadata.RowGroupIndex;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.metadata.statistics.ColumnStatistics;
import io.prestosql.orc.metadata.statistics.SliceColumnStatisticsBuilder;
import io.prestosql.orc.stream.ByteArrayOutputStream;
import io.prestosql.orc.stream.LongOutputStream;
import io.prestosql.orc.stream.PresentOutputStream;
import io.prestosql.orc.stream.StreamDataOutput;
import io.prestosql.orc.writer.ColumnWriter;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.openjdk.jol.info.ClassLayout;

public class SliceDirectColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDirectColumnWriter.class).instanceSize();
    private final int column;
    private final Type type;
    private final boolean compressed;
    private final ColumnEncoding columnEncoding;
    private final LongOutputStream lengthStream;
    private final ByteArrayOutputStream dataStream;
    private final PresentOutputStream presentStream;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private final Supplier<SliceColumnStatisticsBuilder> statisticsBuilderSupplier;
    private SliceColumnStatisticsBuilder statisticsBuilder;
    private boolean closed;

    public SliceDirectColumnWriter(int column, Type type, CompressionKind compression, int bufferSize, Supplier<SliceColumnStatisticsBuilder> statisticsBuilderSupplier) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        this.column = column;
        this.type = Objects.requireNonNull(type, "type is null");
        this.compressed = Objects.requireNonNull(compression, "compression is null") != CompressionKind.NONE;
        this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT_V2, 0);
        this.lengthStream = LongOutputStream.createLengthOutputStream(compression, bufferSize);
        this.dataStream = new ByteArrayOutputStream(compression, bufferSize);
        this.presentStream = new PresentOutputStream(compression, bufferSize);
        this.statisticsBuilderSupplier = statisticsBuilderSupplier;
        this.statisticsBuilder = statisticsBuilderSupplier.get();
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        return ImmutableMap.of((Object)this.column, (Object)this.columnEncoding);
    }

    @Override
    public void beginRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.presentStream.recordCheckpoint();
        this.lengthStream.recordCheckpoint();
        this.dataStream.recordCheckpoint();
    }

    @Override
    public void writeBlock(Block block) {
        int position;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        for (position = 0; position < block.getPositionCount(); ++position) {
            this.presentStream.writeBoolean(!block.isNull(position));
        }
        for (position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            Slice value = this.type.getSlice(block, position);
            this.lengthStream.writeLong(value.length());
            this.dataStream.writeSlice(value);
            this.statisticsBuilder.addValue(value);
        }
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        this.rowGroupColumnStatistics.add(statistics);
        this.statisticsBuilder = this.statisticsBuilderSupplier.get();
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closed = true;
        this.lengthStream.close();
        this.dataStream.close();
        this.presentStream.close();
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
    }

    @Override
    public List<StreamDataOutput> getIndexStreams(CompressedMetadataWriter metadataWriter) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List lengthCheckpoints = this.lengthStream.getCheckpoints();
        List<ByteArrayStreamCheckpoint> dataCheckpoints = this.dataStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        int i = 0;
        while (i < this.rowGroupColumnStatistics.size()) {
            int groupId = i++;
            ColumnStatistics columnStatistics = this.rowGroupColumnStatistics.get(groupId);
            LongStreamCheckpoint lengthCheckpoint = (LongStreamCheckpoint)lengthCheckpoints.get(groupId);
            ByteArrayStreamCheckpoint dataCheckpoint = dataCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = SliceDirectColumnWriter.createSliceColumnPositionList(this.compressed, lengthCheckpoint, dataCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = metadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.column, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    private static List<Integer> createSliceColumnPositionList(boolean compressed, LongStreamCheckpoint lengthCheckpoint, ByteArrayStreamCheckpoint dataCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(dataCheckpoint.toPositionList(compressed));
        positionList.addAll(lengthCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.column).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.lengthStream.getStreamDataOutput(this.column));
        outputDataStreams.add((Object)this.dataStream.getStreamDataOutput(this.column));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.lengthStream.getBufferedBytes() + this.dataStream.getBufferedBytes() + this.presentStream.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        long retainedBytes = (long)INSTANCE_SIZE + this.lengthStream.getRetainedBytes() + this.dataStream.getRetainedBytes() + this.presentStream.getRetainedBytes();
        for (ColumnStatistics statistics : this.rowGroupColumnStatistics) {
            retainedBytes += statistics.getRetainedSizeInBytes();
        }
        return retainedBytes;
    }

    @Override
    public void reset() {
        Preconditions.checkState((boolean)this.closed);
        this.closed = false;
        this.lengthStream.reset();
        this.dataStream.reset();
        this.presentStream.reset();
        this.rowGroupColumnStatistics.clear();
        this.statisticsBuilder = this.statisticsBuilderSupplier.get();
    }
}

