/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.EquatableValueSet;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.Utils;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class DomainConverter {
    private DomainConverter() {
    }

    public static TupleDomain<HiveColumnHandle> convertTupleDomainTypes(TupleDomain<HiveColumnHandle> tupleDomain) {
        if (tupleDomain.isAll() || tupleDomain.isNone()) {
            return tupleDomain;
        }
        if (!tupleDomain.getDomains().isPresent()) {
            return tupleDomain;
        }
        HashMap transformedMap = new HashMap();
        ((Map)tupleDomain.getDomains().get()).forEach((column, domain) -> {
            ValueSet valueSet;
            ValueSet transformedValueSet = valueSet = domain.getValues();
            Type type = domain.getType();
            String baseType = type.getTypeSignature().getBase();
            if (type.equals(TimestampType.TIMESTAMP) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || type.equals(TimeType.TIME) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
                if (valueSet instanceof EquatableValueSet) {
                    EquatableValueSet equatableValueSet = (EquatableValueSet)valueSet;
                    Set values = (Set)equatableValueSet.getEntries().stream().map(value -> EquatableValueSet.ValueEntry.create((Type)value.getType(), (Object)DomainConverter.convertToMicros(baseType, (Long)value.getValue()))).collect(ImmutableSet.toImmutableSet());
                    transformedValueSet = new EquatableValueSet(equatableValueSet.getType(), equatableValueSet.isWhiteList(), values);
                } else if (valueSet instanceof SortedRangeSet) {
                    ArrayList<Range> ranges = new ArrayList<Range>();
                    for (Range range : valueSet.getRanges().getOrderedRanges()) {
                        Marker high;
                        Marker low = range.getLow();
                        if (low.getValueBlock().isPresent()) {
                            Block value2 = Utils.nativeValueToBlock((Type)type, (Object)DomainConverter.convertToMicros(baseType, (Long)range.getLow().getValue()));
                            low = new Marker(range.getType(), Optional.of(value2), range.getLow().getBound());
                        }
                        if ((high = range.getHigh()).getValueBlock().isPresent()) {
                            Block value3 = Utils.nativeValueToBlock((Type)type, (Object)DomainConverter.convertToMicros(baseType, (Long)range.getHigh().getValue()));
                            high = new Marker(range.getType(), Optional.of(value3), range.getHigh().getBound());
                        }
                        ranges.add(new Range(low, high));
                    }
                    transformedValueSet = SortedRangeSet.copyOf((Type)valueSet.getType(), ranges);
                }
                transformedMap.put(column, Domain.create((ValueSet)transformedValueSet, (boolean)domain.isNullAllowed()));
            }
        });
        return TupleDomain.withColumnDomains(transformedMap);
    }

    private static long convertToMicros(String type, long value) {
        switch (type) {
            case "timestamp with time zone": 
            case "time with time zone": {
                return TimeUnit.MILLISECONDS.toMicros(DateTimeEncoding.unpackMillisUtc((long)value));
            }
            case "time": 
            case "timestamp": {
                return TimeUnit.MILLISECONDS.toMicros(value);
            }
        }
        throw new IllegalArgumentException(type + " is unsupported");
    }
}

