/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveSchemaProperties;
import io.prestosql.plugin.hive.HiveWriteUtils;
import io.prestosql.plugin.hive.HiveWrittenPartitions;
import io.prestosql.plugin.hive.TableAlreadyExistsException;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.iceberg.CommitTaskData;
import io.prestosql.plugin.iceberg.ExpressionConverter;
import io.prestosql.plugin.iceberg.HiveTableOperations;
import io.prestosql.plugin.iceberg.IcebergInputInfo;
import io.prestosql.plugin.iceberg.IcebergTableHandle;
import io.prestosql.plugin.iceberg.IcebergTableProperties;
import io.prestosql.plugin.iceberg.IcebergUtil;
import io.prestosql.plugin.iceberg.IcebergWritableTableHandle;
import io.prestosql.plugin.iceberg.PartitionData;
import io.prestosql.plugin.iceberg.PartitionFields;
import io.prestosql.plugin.iceberg.PartitionTable;
import io.prestosql.plugin.iceberg.TableType;
import io.prestosql.plugin.iceberg.TypeConveter;
import io.prestosql.plugin.iceberg.UnknownTableTypeException;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TypeManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class IcebergMetadata
implements ConnectorMetadata {
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final JsonCodec<CommitTaskData> commitTaskCodec;
    private Transaction transaction;

    public IcebergMetadata(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, JsonCodec<CommitTaskData> commitTaskCodec) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metastore.getAllDatabases();
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        IcebergTableHandle handle = IcebergTableHandle.from(tableName);
        Optional table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName());
        if (!table.isPresent()) {
            return null;
        }
        if (!IcebergUtil.isIcebergTable((io.prestosql.plugin.hive.metastore.Table)table.get())) {
            throw new UnknownTableTypeException(tableName);
        }
        return handle;
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        IcebergTableHandle table = IcebergTableHandle.from(tableName);
        if (table.getTableType() == TableType.PARTITIONS) {
            Configuration configuration = this.getConfiguration(session, tableName.getSchemaName());
            Table icebergTable = IcebergUtil.getIcebergTable(table.getSchemaName(), table.getTableName(), configuration, this.metastore);
            return Optional.of(new PartitionTable(table, session, this.typeManager, icebergTable));
        }
        return Optional.empty();
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new ConnectorTableProperties();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        return this.getTableMetadata(session, ((IcebergTableHandle)table).getSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return schemaName.map(Collections::singletonList).orElseGet(() -> ((HiveMetastore)this.metastore).getAllDatabases()).stream().flatMap(schema -> this.metastore.getAllTables(schema).stream().map(table -> new SchemaTableName(schema, table)).collect(Collectors.toList()).stream()).collect(Collectors.toList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Configuration configuration = this.getConfiguration(session, table.getSchemaName());
        Table icebergTable = IcebergUtil.getIcebergTable(table.getSchemaName(), table.getTableName(), configuration, this.metastore);
        List<HiveColumnHandle> columns = IcebergUtil.getColumns(icebergTable.schema(), icebergTable.spec(), this.typeManager);
        return columns.stream().collect(Collectors.toMap(HiveColumnHandle::getName, Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        HiveColumnHandle column = (HiveColumnHandle)columnHandle;
        return new ColumnMetadata(column.getName(), this.typeManager.getType(column.getTypeSignature()));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        List tables = prefix.getTable().map(ignored -> Collections.singletonList(prefix.toSchemaTableName())).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName table : tables) {
            try {
                columns.put((Object)table, (Object)this.getTableMetadata(session, table).getColumns());
            }
            catch (TableNotFoundException tableNotFoundException) {
            }
            catch (UnknownTableTypeException unknownTableTypeException) {}
        }
        return columns.build();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        Optional<String> location = HiveSchemaProperties.getLocation(properties).map(uri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, schemaName), new Path(uri));
            }
            catch (IOException | IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + uri, (Throwable)e);
            }
            return uri;
        });
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(PrincipalType.USER).setOwnerName(session.getUser()).build();
        this.metastore.createDatabase(database);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        if (!this.listTables(session, Optional.of(schemaName)).isEmpty() || !this.listViews(session, Optional.of(schemaName)).isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
        this.metastore.dropDatabase(schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.metastore.renameDatabase(source, target);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Optional layout = this.getNewTableLayout(session, tableMetadata);
        this.finishCreateTable(session, this.beginCreateTable(session, tableMetadata, layout), (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Schema schema = IcebergMetadata.toIcebergSchema(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, schemaName, tableName);
        Database database = (Database)this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        Path targetPath = HiveWriteUtils.getTableDefaultLocation((Database)database, (HdfsEnvironment.HdfsContext)hdfsContext, (HdfsEnvironment)this.hdfsEnvironment, (String)schemaName, (String)tableName);
        Configuration configuration = this.hdfsEnvironment.getConfiguration(hdfsContext, targetPath);
        HiveTableOperations operations = new HiveTableOperations(configuration, this.metastore, schemaName, tableName, session.getUser(), targetPath.toString());
        if (operations.current() != null) {
            throw new TableAlreadyExistsException(schemaTableName);
        }
        TableMetadata metadata = TableMetadata.newTableMetadata((TableOperations)operations, (Schema)schema, (PartitionSpec)partitionSpec, (String)targetPath.toString());
        this.transaction = Transactions.createTableTransaction((TableOperations)operations, (TableMetadata)metadata);
        return new IcebergWritableTableHandle(schemaName, tableName, SchemaParser.toJson((Schema)metadata.schema()), PartitionSpecParser.toJson((PartitionSpec)metadata.spec()), IcebergUtil.getColumns(metadata.schema(), metadata.spec(), this.typeManager), targetPath.toString(), IcebergTableProperties.getFileFormat(tableMetadata.getProperties()));
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return this.finishInsert(session, (IcebergWritableTableHandle)tableHandle, fragments, computedStatistics);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Configuration configuration = this.getConfiguration(session, table.getSchemaName());
        Table icebergTable = IcebergUtil.getIcebergTable(table.getSchemaName(), table.getTableName(), configuration, this.metastore);
        for (Types.NestedField column : icebergTable.schema().columns()) {
            io.prestosql.spi.type.Type type = TypeConveter.toPrestoType(column.type(), this.typeManager);
            if (type instanceof DecimalType) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to columns of type decimal not yet supported");
            }
            if (!(type instanceof TimestampType)) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to columns of type timestamp not yet supported");
        }
        this.transaction = icebergTable.newTransaction();
        return new IcebergWritableTableHandle(table.getSchemaName(), table.getTableName(), SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), icebergTable.spec(), this.typeManager), IcebergUtil.getDataPath(icebergTable.location()), IcebergUtil.getFileFormat(icebergTable));
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        Table icebergTable = this.transaction.table();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = this.transaction.newFastAppend();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withInputFile((InputFile)HadoopInputFile.fromLocation((CharSequence)task.getPath(), (Configuration)this.getConfiguration(session, table.getSchemaName()))).withFormat(table.getFileFormat()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
        }
        appendFiles.commit();
        this.transaction.commitTransaction();
        return Optional.of(new HiveWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::getPath).collect(ImmutableList.toImmutableList())));
    }

    public Optional<Object> getInfo(ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        return Optional.of(new IcebergInputInfo(table.getSnapshotId()));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        this.metastore.dropTable(handle.getSchemaName(), handle.getTableName(), true);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTable) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        this.metastore.renameTable(handle.getSchemaName(), handle.getTableName(), newTable.getSchemaName(), newTable.getTableName());
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Configuration configuration = this.getConfiguration(session, handle.getSchemaName());
        Table icebergTable = IcebergUtil.getIcebergTable(handle.getSchemaName(), handle.getTableName(), configuration, this.metastore);
        icebergTable.updateSchema().addColumn(column.getName(), TypeConveter.toIcebergType(column.getType())).commit();
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        HiveColumnHandle handle = (HiveColumnHandle)column;
        Configuration configuration = this.getConfiguration(session, icebergTableHandle.getSchemaName());
        Table icebergTable = IcebergUtil.getIcebergTable(icebergTableHandle.getSchemaName(), icebergTableHandle.getTableName(), configuration, this.metastore);
        icebergTable.updateSchema().deleteColumn(handle.getName()).commit();
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        HiveColumnHandle columnHandle = (HiveColumnHandle)source;
        Configuration configuration = this.getConfiguration(session, icebergTableHandle.getSchemaName());
        Table icebergTable = IcebergUtil.getIcebergTable(icebergTableHandle.getSchemaName(), icebergTableHandle.getTableName(), configuration, this.metastore);
        icebergTable.updateSchema().renameColumn(columnHandle.getName(), target).commit();
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName schemaTableName) {
        String tableName;
        String schema = schemaTableName.getSchemaName();
        if (!this.metastore.getTable(schema, tableName = schemaTableName.getTableName()).isPresent()) {
            throw new TableNotFoundException(schemaTableName);
        }
        Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, schema), new Path("file:///tmp"));
        Table icebergTable = IcebergUtil.getIcebergTable(schema, tableName, configuration, this.metastore);
        List<ColumnMetadata> columns = this.getColumnMetadatas(icebergTable);
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"format", (Object)IcebergUtil.getFileFormat(icebergTable));
        if (!icebergTable.spec().fields().isEmpty()) {
            properties.put((Object)"partitioning", PartitionFields.toPartitionFields(icebergTable.spec()));
        }
        return new ConnectorTableMetadata(schemaTableName, columns, (Map)properties.build(), Optional.empty());
    }

    private List<ColumnMetadata> getColumnMetadatas(Table table) {
        return (List)table.schema().columns().stream().map(column -> new ColumnMetadata(column.name(), TypeConveter.toPrestoType(column.type(), this.typeManager))).collect(ImmutableList.toImmutableList());
    }

    private static Schema toIcebergSchema(List<ColumnMetadata> columns) {
        ArrayList<Types.NestedField> icebergColumns = new ArrayList<Types.NestedField>();
        for (ColumnMetadata column : columns) {
            if (column.isHidden()) continue;
            int index = icebergColumns.size();
            Type type = TypeConveter.toIcebergType(column.getType());
            Types.NestedField field = column.isNullable() ? Types.NestedField.optional((int)index, (String)column.getName(), (Type)type, (String)column.getComment()) : Types.NestedField.required((int)index, (String)column.getName(), (Type)type, (String)column.getComment());
            icebergColumns.add(field);
        }
        Schema schema = new Schema(icebergColumns);
        AtomicInteger nextFieldId = new AtomicInteger(1);
        return TypeUtil.assignFreshIds((Schema)schema, nextFieldId::getAndIncrement);
    }

    private Configuration getConfiguration(ConnectorSession session, String schemaName) {
        return this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, schemaName), new Path("file:///tmp"));
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return HiveColumnHandle.updateRowIdHandle();
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.of(handle);
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector only supports delete where one or more partitions are deleted entirely");
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Configuration configuration = this.getConfiguration(session, handle.getSchemaName());
        Table icebergTable = IcebergUtil.getIcebergTable(handle.getSchemaName(), handle.getTableName(), configuration, this.metastore);
        icebergTable.newDelete().deleteFromRowFilter(ExpressionConverter.toIcebergExpression(handle.getPredicate(), session)).commit();
        return OptionalLong.empty();
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public HiveMetastore getMetastore() {
        return this.metastore;
    }

    public void rollback() {
    }
}

