/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveFileWriter;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.ParquetRecordWriterUtil;
import io.prestosql.plugin.hive.RecordFileWriter;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.plugin.iceberg.CommitTaskData;
import io.prestosql.plugin.iceberg.IcebergErrorCode;
import io.prestosql.plugin.iceberg.MetricsWrapper;
import io.prestosql.plugin.iceberg.PartitionData;
import io.prestosql.plugin.iceberg.PartitionTransforms;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageIndexer;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.transforms.Transform;
import org.apache.parquet.schema.MessageType;

public class IcebergPageSink
implements ConnectorPageSink {
    private static final int MAX_PAGE_POSITIONS = 4096;
    private final int maxOpenWriters = 100;
    private final Schema outputSchema;
    private final PartitionSpec partitionSpec;
    private final String outputPath;
    private final HdfsEnvironment hdfsEnvironment;
    private final JobConf jobConf;
    private final List<HiveColumnHandle> inputColumns;
    private final JsonCodec<CommitTaskData> jsonCodec;
    private final ConnectorSession session;
    private final TypeManager typeManager;
    private final FileFormat fileFormat;
    private final PagePartitioner pagePartitioner;
    private final List<WriteContext> writers = new ArrayList<WriteContext>();
    private long writtenBytes;
    private long systemMemoryUsage;
    private long validationCpuNanos;

    public IcebergPageSink(Schema outputSchema, PartitionSpec partitionSpec, String outputPath, PageIndexerFactory pageIndexerFactory, HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext hdfsContext, List<HiveColumnHandle> inputColumns, TypeManager typeManager, JsonCodec<CommitTaskData> jsonCodec, ConnectorSession session, FileFormat fileFormat) {
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        this.outputSchema = Objects.requireNonNull(outputSchema, "outputSchema is null");
        this.partitionSpec = Objects.requireNonNull(partitionSpec, "partitionSpec is null");
        this.outputPath = Objects.requireNonNull(outputPath, "outputPath is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        Objects.requireNonNull(hdfsContext, "hdfsContext is null");
        this.jobConf = ConfigurationUtils.toJobConf((Configuration)hdfsEnvironment.getConfiguration(hdfsContext, new Path(outputPath)));
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat is null");
        this.inputColumns = ImmutableList.copyOf(inputColumns);
        this.pagePartitioner = new PagePartitioner(pageIndexerFactory, IcebergPageSink.toPartitionColumns(typeManager, inputColumns, partitionSpec));
    }

    public long getCompletedBytes() {
        return this.writtenBytes;
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryUsage;
    }

    public long getValidationCpuNanos() {
        return this.validationCpuNanos;
    }

    public CompletableFuture<?> appendPage(Page page) {
        this.hdfsEnvironment.doAs(this.session.getUser(), () -> this.doAppend(page));
        return NOT_BLOCKED;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        ArrayList<Slice> commitTasks = new ArrayList<Slice>();
        for (WriteContext context : this.writers) {
            context.getWriter().commit();
            CommitTaskData task = new CommitTaskData(context.getPath().toString(), new MetricsWrapper(this.readMetrics(context.getPath())), context.getPartitionData().map(PartitionData::toJson));
            commitTasks.add(Slices.wrappedBuffer((byte[])this.jsonCodec.toJsonBytes((Object)task)));
        }
        this.writtenBytes = this.writers.stream().mapToLong(writer -> writer.getWriter().getWrittenBytes()).sum();
        this.validationCpuNanos = this.writers.stream().mapToLong(writer -> writer.getWriter().getValidationCpuNanos()).sum();
        return CompletableFuture.completedFuture(commitTasks);
    }

    public void abort() {
        Throwable error = null;
        for (WriteContext context : this.writers) {
            try {
                if (context == null) continue;
                context.getWriter().rollback();
            }
            catch (Throwable t) {
                if (error == null) {
                    error = new RuntimeException("Exception during rollback");
                }
                error.addSuppressed(t);
            }
        }
        if (error != null) {
            throw error;
        }
    }

    private void doAppend(Page page) {
        while (page.getPositionCount() > 4096) {
            Page chunk = page.getRegion(0, 4096);
            page = page.getRegion(4096, page.getPositionCount() - 4096);
            this.writePage(chunk);
        }
        this.writePage(page);
    }

    private void writePage(Page page) {
        int index;
        int[] writerIndexes = this.getWriterIndexes(page);
        int[] sizes = new int[this.writers.size()];
        int[] nArray = writerIndexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = index = nArray[i];
            sizes[n2] = sizes[n2] + 1;
        }
        int[][] writerPositions = new int[this.writers.size()][];
        int[] counts = new int[this.writers.size()];
        int position = 0;
        while (position < page.getPositionCount()) {
            index = writerIndexes[position];
            int count = counts[index];
            if (count == 0) {
                writerPositions[index] = new int[sizes[index]];
            }
            writerPositions[index][count] = position++;
            int n3 = index;
            counts[n3] = counts[n3] + 1;
        }
        for (int index2 = 0; index2 < writerPositions.length; ++index2) {
            int[] positions = writerPositions[index2];
            if (positions == null) continue;
            Page pageForWriter = page;
            if (positions.length != page.getPositionCount()) {
                Verify.verify((positions.length == counts[index2] ? 1 : 0) != 0);
                pageForWriter = pageForWriter.getPositions(positions, 0, positions.length);
            }
            HiveFileWriter writer = this.writers.get(index2).getWriter();
            long currentWritten = writer.getWrittenBytes();
            long currentMemory = writer.getSystemMemoryUsage();
            writer.appendRows(pageForWriter);
            this.writtenBytes += writer.getWrittenBytes() - currentWritten;
            this.systemMemoryUsage += writer.getSystemMemoryUsage() - currentMemory;
        }
    }

    private int[] getWriterIndexes(Page page) {
        int[] writerIndexes = this.pagePartitioner.partitionPage(page);
        if (this.pagePartitioner.getMaxIndex() >= 100) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_TOO_MANY_OPEN_PARTITIONS, String.format("Exceeded limit of %s open writers for partitions", 100));
        }
        while (this.writers.size() <= this.pagePartitioner.getMaxIndex()) {
            this.writers.add(null);
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int writerIndex = writerIndexes[position];
            if (this.writers.get(writerIndex) != null) continue;
            Optional<PartitionData> partitionData = IcebergPageSink.getPartitionData(this.pagePartitioner.getColumns(), page, position);
            Optional<String> partitionPath = partitionData.map(arg_0 -> ((PartitionSpec)this.partitionSpec).partitionToPath(arg_0));
            WriteContext writer = this.createWriter(partitionPath, partitionData);
            this.writers.set(writerIndex, writer);
        }
        Verify.verify((this.writers.size() == this.pagePartitioner.getMaxIndex() + 1 ? 1 : 0) != 0);
        Verify.verify((!this.writers.contains(null) ? 1 : 0) != 0);
        return writerIndexes;
    }

    private WriteContext createWriter(Optional<String> partitionPath, Optional<PartitionData> partitionData) {
        Path outputPath = new Path(this.outputPath);
        if (partitionPath.isPresent()) {
            outputPath = new Path(outputPath, partitionPath.get());
        }
        outputPath = new Path(outputPath, UUID.randomUUID().toString());
        outputPath = new Path(this.fileFormat.addExtension(outputPath.toString()));
        HiveFileWriter writer = this.createWriter(outputPath);
        return new WriteContext(writer, outputPath, partitionData);
    }

    private HiveFileWriter createWriter(Path outputPath) {
        switch (this.fileFormat) {
            case PARQUET: {
                return this.createParquetWriter(outputPath);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "File format not supported for Iceberg: " + this.fileFormat);
    }

    private HiveFileWriter createParquetWriter(Path outputPath) {
        Properties properties = new Properties();
        properties.setProperty("columns", this.inputColumns.stream().map(HiveColumnHandle::getName).collect(Collectors.joining(",")));
        properties.setProperty("columns.types", this.inputColumns.stream().map(column -> column.getHiveType().getHiveTypeName().toString()).collect(Collectors.joining(":")));
        ParquetRecordWriterUtil.setParquetSchema((Configuration)this.jobConf, (MessageType)ParquetSchemaUtil.convert((Schema)this.outputSchema, (String)"table"));
        return new RecordFileWriter(outputPath, (List)this.inputColumns.stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList()), StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.PARQUET), properties, HiveStorageFormat.PARQUET.getEstimatedWriterSystemMemoryUsage(), this.jobConf, this.typeManager, this.session);
    }

    private Metrics readMetrics(Path path) {
        switch (this.fileFormat) {
            case PARQUET: {
                return ParquetUtil.fileMetrics((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)this.jobConf), (MetricsConfig)MetricsConfig.getDefault());
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "File format not supported for Iceberg: " + this.fileFormat);
    }

    private static Optional<PartitionData> getPartitionData(List<PartitionColumn> columns, Page page, int position) {
        if (columns.isEmpty()) {
            return Optional.empty();
        }
        Object[] values = new Object[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            PartitionColumn column = columns.get(i);
            Block block = page.getBlock(column.getSourceChannel());
            Type type = column.getSourceType();
            Object value = IcebergPageSink.getIcebergValue(block, position, type);
            values[i] = IcebergPageSink.applyTransform(column.getField().transform(), value);
        }
        return Optional.of(new PartitionData(values));
    }

    private static Object applyTransform(Transform<?, ?> transform, Object value) {
        return transform.apply(value);
    }

    public static Object getIcebergValue(Block block, int position, Type type) {
        if (block.isNull(position)) {
            return null;
        }
        switch (type.getTypeSignature().getBase()) {
            case "bigint": {
                return type.getLong(block, position);
            }
            case "integer": 
            case "smallint": 
            case "tinyint": 
            case "date": {
                return Math.toIntExact(type.getLong(block, position));
            }
            case "boolean": {
                return type.getBoolean(block, position);
            }
            case "decimal": {
                return Decimals.readBigDecimal((DecimalType)((DecimalType)type), (Block)block, (int)position);
            }
            case "real": {
                return Float.valueOf(Float.intBitsToFloat(Math.toIntExact(type.getLong(block, position))));
            }
            case "double": {
                return type.getDouble(block, position);
            }
            case "timestamp": {
                return TimeUnit.MILLISECONDS.toMicros(type.getLong(block, position));
            }
            case "timestamp with time zone": {
                return TimeUnit.MILLISECONDS.toMicros(DateTimeEncoding.unpackMillisUtc((long)type.getLong(block, position)));
            }
            case "varbinary": {
                return type.getSlice(block, position).getBytes();
            }
            case "varchar": {
                return type.getSlice(block, position).toStringUtf8();
            }
        }
        throw new UnsupportedOperationException("Type not supported as partition column: " + type.getDisplayName());
    }

    private static List<PartitionColumn> toPartitionColumns(TypeManager typeManager, List<HiveColumnHandle> handles, PartitionSpec partitionSpec) {
        HashMap<String, Integer> nameChannels = new HashMap<String, Integer>();
        for (int i = 0; i < handles.size(); ++i) {
            nameChannels.put(handles.get(i).getName(), i);
        }
        return (List)partitionSpec.fields().stream().map(field -> {
            String name = partitionSpec.schema().findColumnName(field.sourceId());
            Integer channel = (Integer)nameChannels.get(name);
            Preconditions.checkArgument((channel != null ? 1 : 0) != 0, (String)"partition field not found: %s", (Object)field);
            Type inputType = typeManager.getType(((HiveColumnHandle)handles.get(channel)).getTypeSignature());
            PartitionTransforms.ColumnTransform transform = PartitionTransforms.getColumnTransform(field, inputType);
            return new PartitionColumn((PartitionField)field, channel, inputType, transform.getType(), transform.getTransform());
        }).collect(ImmutableList.toImmutableList());
    }

    private static class PartitionColumn {
        private final PartitionField field;
        private final int sourceChannel;
        private final Type sourceType;
        private final Type resultType;
        private final Function<Block, Block> blockTransform;

        public PartitionColumn(PartitionField field, int sourceChannel, Type sourceType, Type resultType, Function<Block, Block> blockTransform) {
            this.field = Objects.requireNonNull(field, "field is null");
            this.sourceChannel = sourceChannel;
            this.sourceType = Objects.requireNonNull(sourceType, "sourceType is null");
            this.resultType = Objects.requireNonNull(resultType, "resultType is null");
            this.blockTransform = Objects.requireNonNull(blockTransform, "blockTransform is null");
        }

        public PartitionField getField() {
            return this.field;
        }

        public int getSourceChannel() {
            return this.sourceChannel;
        }

        public Type getSourceType() {
            return this.sourceType;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public Function<Block, Block> getBlockTransform() {
            return this.blockTransform;
        }
    }

    private static class PagePartitioner {
        private final PageIndexer pageIndexer;
        private final List<PartitionColumn> columns;

        public PagePartitioner(PageIndexerFactory pageIndexerFactory, List<PartitionColumn> columns) {
            this.pageIndexer = pageIndexerFactory.createPageIndexer((List)columns.stream().map(PartitionColumn::getResultType).collect(ImmutableList.toImmutableList()));
            this.columns = ImmutableList.copyOf(columns);
        }

        public int[] partitionPage(Page page) {
            Block[] blocks = new Block[this.columns.size()];
            for (int i = 0; i < this.columns.size(); ++i) {
                PartitionColumn column = this.columns.get(i);
                Block block = page.getBlock(column.getSourceChannel());
                blocks[i] = column.getBlockTransform().apply(block);
            }
            Page transformed = new Page(page.getPositionCount(), blocks);
            return this.pageIndexer.indexPage(transformed);
        }

        public int getMaxIndex() {
            return this.pageIndexer.getMaxIndex();
        }

        public List<PartitionColumn> getColumns() {
            return this.columns;
        }
    }

    private static class WriteContext {
        private final HiveFileWriter writer;
        private final Path path;
        private final Optional<PartitionData> partitionData;

        public WriteContext(HiveFileWriter writer, Path path, Optional<PartitionData> partitionData) {
            this.writer = Objects.requireNonNull(writer, "writer is null");
            this.path = Objects.requireNonNull(path, "path is null");
            this.partitionData = Objects.requireNonNull(partitionData, "partitionData is null");
        }

        public HiveFileWriter getWriter() {
            return this.writer;
        }

        public Path getPath() {
            return this.path;
        }

        public Optional<PartitionData> getPartitionData() {
            return this.partitionData;
        }
    }
}

