/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import io.airlift.json.JsonCodec;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.iceberg.CommitTaskData;
import io.prestosql.plugin.iceberg.IcebergPageSink;
import io.prestosql.plugin.iceberg.IcebergWritableTableHandle;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.TypeManager;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;

public class IcebergPageSinkProvider
implements ConnectorPageSinkProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final JsonCodec<CommitTaskData> jsonCodec;
    private final TypeManager typeManager;
    private final PageIndexerFactory pageIndexerFactory;

    @Inject
    public IcebergPageSinkProvider(HdfsEnvironment hdfsEnvironment, JsonCodec<CommitTaskData> jsonCodec, TypeManager typeManager, PageIndexerFactory pageIndexerFactory) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
        return this.createPageSink(session, (IcebergWritableTableHandle)outputTableHandle);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
        return this.createPageSink(session, (IcebergWritableTableHandle)insertTableHandle);
    }

    private ConnectorPageSink createPageSink(ConnectorSession session, IcebergWritableTableHandle tableHandle) {
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, tableHandle.getSchemaName(), tableHandle.getTableName());
        Schema schema = SchemaParser.fromJson((String)tableHandle.getSchemaAsJson());
        PartitionSpec partitionSpec = PartitionSpecParser.fromJson((Schema)schema, (String)tableHandle.getPartitionSpecAsJson());
        return new IcebergPageSink(schema, partitionSpec, tableHandle.getOutputPath(), this.pageIndexerFactory, this.hdfsEnvironment, hdfsContext, tableHandle.getInputColumns(), this.typeManager, this.jsonCodec, session, tableHandle.getFileFormat());
    }
}

