/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.parquet.ParquetCorruptionException;
import io.prestosql.parquet.ParquetDataSource;
import io.prestosql.parquet.ParquetTypeUtils;
import io.prestosql.parquet.predicate.Predicate;
import io.prestosql.parquet.predicate.PredicateUtils;
import io.prestosql.parquet.reader.MetadataReader;
import io.prestosql.parquet.reader.ParquetReader;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePageSource;
import io.prestosql.plugin.hive.HivePageSourceProvider;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.parquet.HdfsParquetDataSource;
import io.prestosql.plugin.hive.parquet.ParquetPageSource;
import io.prestosql.plugin.hive.parquet.ParquetPageSourceFactory;
import io.prestosql.plugin.iceberg.IcebergSessionProperties;
import io.prestosql.plugin.iceberg.IcebergSplit;
import io.prestosql.plugin.iceberg.IcebergTableHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.TypeManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.joda.time.DateTimeZone;

public class IcebergPageSourceProvider
implements ConnectorPageSourceProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;

    @Inject
    public IcebergPageSourceProvider(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, FileFormatDataSourceStats fileFormatDataSourceStats) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit connectorSplit, ConnectorTableHandle connectorTable, List<ColumnHandle> columns) {
        IcebergSplit split = (IcebergSplit)connectorSplit;
        IcebergTableHandle table = (IcebergTableHandle)connectorTable;
        Path path = new Path(split.getPath());
        long start = split.getStart();
        long length = split.getLength();
        List<HiveColumnHandle> hiveColumns = columns.stream().map(HiveColumnHandle.class::cast).collect(Collectors.toList());
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getSchemaName(), table.getTableName());
        return IcebergPageSourceProvider.createParquetPageSource(this.hdfsEnvironment, session.getUser(), this.hdfsEnvironment.getConfiguration(hdfsContext, path), path, start, length, hiveColumns, split.getNameToId(), false, this.typeManager, IcebergSessionProperties.getParquetMaxReadBlockSize(session), IcebergSessionProperties.isFailOnCorruptedParquetStatistics(session), split.getPredicate(), split.getPartitionKeys(), this.fileFormatDataSourceStats);
    }

    private static ConnectorPageSource createParquetPageSource(HdfsEnvironment hdfsEnvironment, String user, Configuration configuration, Path path, long start, long length, List<HiveColumnHandle> columns, Map<String, Integer> icebergNameToId, boolean useParquetColumnNames, TypeManager typeManager, DataSize maxReadBlockSize, boolean failOnCorruptedStatistics, TupleDomain<HiveColumnHandle> effectivePredicate, List<HivePartitionKey> partitionKeys, FileFormatDataSourceStats fileFormatDataSourceStats) {
        AggregatedMemoryContext systemMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        HdfsParquetDataSource dataSource = null;
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            long fileSize = fileSystem.getFileStatus(path).getLen();
            FSDataInputStream inputStream = (FSDataInputStream)hdfsEnvironment.doAs(user, () -> fileSystem.open(path));
            dataSource = HdfsParquetDataSource.buildHdfsParquetDataSource((FSDataInputStream)inputStream, (Path)path, (long)fileSize, (FileFormatDataSourceStats)fileFormatDataSourceStats);
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((FileSystem)fileSystem, (Path)path, (long)fileSize);
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            Map<String, HiveColumnHandle> parquetColumns = IcebergPageSourceProvider.convertToParquetNames(columns, icebergNameToId, fileSchema);
            List fields = parquetColumns.values().stream().filter(column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR).map(column -> ParquetPageSourceFactory.getParquetType((HiveColumnHandle)column, (MessageType)fileSchema, (boolean)true)).filter(Objects::nonNull).collect(Collectors.toList());
            MessageType requestedSchema = new MessageType(fileSchema.getName(), fields);
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain parquetTupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, effectivePredicate);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, (TupleDomain)parquetTupleDomain, (Map)descriptorsByPath);
            ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < start || firstDataPage >= start + length || !PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)dataSource, (Map)descriptorsByPath, (TupleDomain)parquetTupleDomain, (boolean)failOnCorruptedStatistics)) continue;
                blocks.add(block);
            }
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ParquetReader parquetReader = new ParquetReader(messageColumnIO, blocks, (ParquetDataSource)dataSource, systemMemoryContext, maxReadBlockSize);
            List columnMappings = HivePageSourceProvider.ColumnMapping.buildColumnMappings(partitionKeys, (List)((List)columns.stream().filter(column -> !column.isHidden()).collect(ImmutableList.toImmutableList())), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (Path)path, (OptionalInt)OptionalInt.empty());
            List columnNameReplaced = (List)columns.stream().filter(column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR).map(column -> parquetColumns.getOrDefault(column.getName(), (HiveColumnHandle)column)).collect(ImmutableList.toImmutableList());
            ParquetPageSource parquetPageSource = new ParquetPageSource(parquetReader, fileSchema, messageColumnIO, typeManager, new Properties(), columnNameReplaced, useParquetColumnNames);
            return new HivePageSource(columnMappings, Optional.empty(), DateTimeZone.UTC, typeManager, (ConnectorPageSource)parquetPageSource);
        }
        catch (IOException | RuntimeException e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException fileSize) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)e;
            }
            String message = String.format("Error opening Iceberg split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e instanceof ParquetCorruptionException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, message, (Throwable)e);
            }
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static Map<String, HiveColumnHandle> convertToParquetNames(List<HiveColumnHandle> columns, Map<String, Integer> icebergNameToId, MessageType parquetSchema) {
        List fields = parquetSchema.getFields();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map<Integer, String> parquetIdToName = fields.stream().filter(field -> field.getId() != null).collect(Collectors.toMap(x -> x.getId().intValue(), Type::getName));
        for (HiveColumnHandle column : columns) {
            if (column.isHidden()) continue;
            String name = column.getName();
            Integer id = icebergNameToId.get(name);
            if (parquetIdToName.containsKey(id)) {
                String parquetName = parquetIdToName.get(id);
                HiveColumnHandle columnHandle = new HiveColumnHandle(parquetName, column.getHiveType(), column.getTypeSignature(), column.getHiveColumnIndex(), column.getColumnType(), column.getComment());
                builder.put((Object)name, (Object)columnHandle);
                continue;
            }
            if (!parquetIdToName.isEmpty()) continue;
            builder.put((Object)name, (Object)column);
        }
        return builder.build();
    }
}

