/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.OrcFileWriterConfig;
import io.prestosql.plugin.hive.ParquetFileWriterConfig;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.session.PropertyMetadata;
import java.util.List;
import javax.inject.Inject;

public final class IcebergSessionProperties {
    private static final String PARQUET_FAIL_WITH_CORRUPTED_STATISTICS = "parquet_fail_with_corrupted_statistics";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_WRITER_BLOCK_SIZE = "parquet_writer_block_size";
    private static final String PARQUET_WRITER_PAGE_SIZE = "parquet_writer_page_size";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public IcebergSessionProperties(HiveConfig hiveConfig, OrcFileWriterConfig orcFileWriterConfig, ParquetFileWriterConfig parquetFileWriterConfig) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadata.booleanProperty((String)PARQUET_FAIL_WITH_CORRUPTED_STATISTICS, (String)"Parquet: Fail when scanning Parquet files with corrupted statistics", (Boolean)hiveConfig.isFailOnCorruptedParquetStatistics(), (boolean)false)).add((Object)PropertyMetadata.dataSizeProperty((String)PARQUET_MAX_READ_BLOCK_SIZE, (String)"Parquet: Maximum size of a block to read", (DataSize)hiveConfig.getParquetMaxReadBlockSize(), (boolean)false)).add((Object)PropertyMetadata.dataSizeProperty((String)PARQUET_WRITER_BLOCK_SIZE, (String)"Parquet: Writer block size", (DataSize)parquetFileWriterConfig.getBlockSize(), (boolean)false)).add((Object)PropertyMetadata.dataSizeProperty((String)PARQUET_WRITER_PAGE_SIZE, (String)"Parquet: Writer page size", (DataSize)parquetFileWriterConfig.getPageSize(), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isFailOnCorruptedParquetStatistics(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_FAIL_WITH_CORRUPTED_STATISTICS, Boolean.class);
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }
}

