/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IcebergSplit
implements ConnectorSplit {
    private final String path;
    private final long start;
    private final long length;
    private final List<HostAddress> addresses;
    private final Map<String, Integer> nameToId;
    private final TupleDomain<HiveColumnHandle> predicate;
    private final List<HivePartitionKey> partitionKeys;

    @JsonCreator
    public IcebergSplit(@JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="nameToId") Map<String, Integer> nameToId, @JsonProperty(value="predicate") TupleDomain<HiveColumnHandle> predicate, @JsonProperty(value="partitionKeys") List<HivePartitionKey> partitionKeys) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.start = start;
        this.length = length;
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
        this.nameToId = ImmutableMap.copyOf(Objects.requireNonNull(nameToId, "nameToId is null"));
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.partitionKeys = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionKeys, "partitionKeys is null"));
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public Map<String, Integer> getNameToId() {
        return this.nameToId;
    }

    @JsonProperty
    public TupleDomain<HiveColumnHandle> getPredicate() {
        return this.predicate;
    }

    @JsonProperty
    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)this.start).put((Object)"length", (Object)this.length).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.path).addValue(this.start).addValue(this.length).toString();
    }
}

