/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.iceberg.DomainConverter;
import io.prestosql.plugin.iceberg.IcebergSplit;
import io.prestosql.plugin.iceberg.IcebergUtil;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.predicate.TupleDomain;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class IcebergSplitSource
implements ConnectorSplitSource {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS").withZone(ZoneOffset.UTC);
    private final CloseableIterable<CombinedScanTask> combinedScanIterable;
    private final TupleDomain<HiveColumnHandle> predicate;
    private final Map<String, Integer> nameToId;
    private final Iterator<FileScanTask> fileScanIterator;

    public IcebergSplitSource(CloseableIterable<CombinedScanTask> combinedScanIterable, TupleDomain<HiveColumnHandle> predicate, Schema schema) {
        this.combinedScanIterable = Objects.requireNonNull(combinedScanIterable, "combinedScanIterable is null");
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.nameToId = (Map)Objects.requireNonNull(schema, "schema is null").columns().stream().collect(ImmutableMap.toImmutableMap(Types.NestedField::name, Types.NestedField::fieldId));
        this.fileScanIterator = Streams.stream(combinedScanIterable).map(CombinedScanTask::files).flatMap(Collection::stream).iterator();
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        ArrayList<ConnectorSplit> splits = new ArrayList<ConnectorSplit>();
        TupleDomain<HiveColumnHandle> predicate = DomainConverter.convertTupleDomainTypes(this.predicate);
        Iterator iterator = Iterators.limit(this.fileScanIterator, (int)maxSize);
        while (iterator.hasNext()) {
            FileScanTask task = (FileScanTask)iterator.next();
            splits.add(this.toIcebergSplit(predicate, task));
        }
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished()));
    }

    public boolean isFinished() {
        return !this.fileScanIterator.hasNext();
    }

    public void close() {
        try {
            this.combinedScanIterable.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ConnectorSplit toIcebergSplit(TupleDomain<HiveColumnHandle> predicate, FileScanTask task) {
        return new IcebergSplit(task.file().path().toString(), task.start(), task.length(), (List<HostAddress>)ImmutableList.of(), this.nameToId, predicate, IcebergSplitSource.getPartitionKeys(task));
    }

    private static List<HivePartitionKey> getPartitionKeys(FileScanTask scanTask) {
        StructLike partition = scanTask.file().partition();
        PartitionSpec spec = scanTask.spec();
        Map<PartitionField, Integer> fieldToIndex = IcebergUtil.getIdentityPartitions(spec);
        ArrayList<HivePartitionKey> partitionKeys = new ArrayList<HivePartitionKey>();
        fieldToIndex.forEach((field, index) -> {
            String name = field.name();
            Type sourceType = spec.schema().findType(field.sourceId());
            Type partitionType = field.transform().getResultType(sourceType);
            Class javaClass = partitionType.typeId().javaClass();
            Object value = partition.get(index.intValue(), javaClass);
            String partitionValue = "__HIVE_DEFAULT_PARTITION__";
            if (value != null) {
                switch (partitionType.typeId()) {
                    case DATE: {
                        partitionValue = DATE_FORMATTER.format(LocalDate.ofEpochDay(((Integer)value).intValue()));
                        break;
                    }
                    case TIMESTAMP: {
                        partitionValue = TIMESTAMP_FORMATTER.format(IcebergSplitSource.toLocalDateTime((Long)value));
                        break;
                    }
                    case FIXED: 
                    case BINARY: {
                        partitionValue = new String(((ByteBuffer)value).array(), StandardCharsets.UTF_8);
                        break;
                    }
                    default: {
                        partitionValue = value.toString();
                    }
                }
            }
            partitionKeys.add(new HivePartitionKey(name, partitionValue));
        });
        return partitionKeys;
    }

    private static LocalDateTime toLocalDateTime(long epochMicro) {
        long epochSecond = TimeUnit.MICROSECONDS.toSeconds(epochMicro);
        long microOfSecond = epochMicro - TimeUnit.SECONDS.toMicros(epochSecond);
        int nanoOfSecond = Math.toIntExact(TimeUnit.MICROSECONDS.toNanos(microOfSecond));
        return LocalDateTime.ofEpochSecond(epochSecond, nanoOfSecond, ZoneOffset.UTC);
    }
}

