/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.apache.iceberg.FileFormat;

public class IcebergTableProperties {
    public static final String FILE_FORMAT_PROPERTY = "format";
    public static final String PARTITIONING_PROPERTY = "partitioning";
    private final List<PropertyMetadata<?>> tableProperties = ImmutableList.builder().add((Object)PropertyMetadata.enumProperty((String)"format", (String)"File format for the table", FileFormat.class, (Enum)FileFormat.PARQUET, (boolean)false)).add((Object)new PropertyMetadata("partitioning", "Partition transforms", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (ImmutableList)((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value)).build();

    @Inject
    public IcebergTableProperties() {
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static FileFormat getFileFormat(Map<String, Object> tableProperties) {
        return (FileFormat)tableProperties.get(FILE_FORMAT_PROPERTY);
    }

    public static List<String> getPartitioning(Map<String, Object> tableProperties) {
        List partitioning = (List)tableProperties.get(PARTITIONING_PROPERTY);
        return partitioning == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)partitioning);
    }
}

