/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.base.Preconditions;
import io.prestosql.plugin.iceberg.IcebergMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IcebergTransactionManager {
    private final Map<ConnectorTransactionHandle, IcebergMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, IcebergMetadata>();

    public IcebergMetadata get(ConnectorTransactionHandle transaction) {
        IcebergMetadata metadata = this.transactions.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return metadata;
    }

    public IcebergMetadata remove(ConnectorTransactionHandle transaction) {
        IcebergMetadata metadata = this.transactions.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return metadata;
    }

    public void put(ConnectorTransactionHandle transaction, IcebergMetadata metadata) {
        ConnectorMetadata existing = this.transactions.putIfAbsent(transaction, metadata);
        Preconditions.checkState((existing == null ? 1 : 0) != 0, (String)"transaction already exists: %s", (Object)existing);
    }
}

