/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveTypeTranslator;
import io.prestosql.plugin.hive.TypeTranslator;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.iceberg.ExpressionConverter;
import io.prestosql.plugin.iceberg.HiveTableOperations;
import io.prestosql.plugin.iceberg.TypeConveter;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TypeManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

final class IcebergUtil {
    private static final TypeTranslator TYPE_TRANSLATOR = new HiveTypeTranslator();

    private IcebergUtil() {
    }

    public static boolean isIcebergTable(io.prestosql.plugin.hive.metastore.Table table) {
        return "iceberg".equalsIgnoreCase((String)table.getParameters().get("table_type"));
    }

    public static Table getIcebergTable(String database, String tableName, Configuration configuration, HiveMetastore metastore) {
        HiveTableOperations operations = new HiveTableOperations(configuration, metastore, database, tableName);
        return new BaseTable((TableOperations)operations, database + "." + tableName);
    }

    public static List<HiveColumnHandle> getColumns(Schema schema, PartitionSpec spec, TypeManager typeManager) {
        ImmutableList partitionFields = ImmutableList.copyOf(IcebergUtil.getIdentityPartitions(spec).keySet());
        ImmutableMap partitionColumnNames = Maps.uniqueIndex((Iterable)partitionFields, PartitionField::name);
        int columnIndex = 0;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Types.NestedField column : schema.columns()) {
            Type type = column.type();
            HiveColumnHandle.ColumnType columnType = HiveColumnHandle.ColumnType.REGULAR;
            if (partitionColumnNames.containsKey(column.name())) {
                PartitionField partitionField = (PartitionField)partitionColumnNames.get(column.name());
                Type sourceType = schema.findType(partitionField.sourceId());
                type = partitionField.transform().getResultType(sourceType);
                columnType = HiveColumnHandle.ColumnType.PARTITION_KEY;
            }
            io.prestosql.spi.type.Type prestoType = TypeConveter.toPrestoType(type, typeManager);
            HiveType hiveType = HiveType.toHiveType((TypeTranslator)TYPE_TRANSLATOR, (io.prestosql.spi.type.Type)IcebergUtil.coerceForHive(prestoType));
            HiveColumnHandle columnHandle = new HiveColumnHandle(column.name(), hiveType, prestoType.getTypeSignature(), columnIndex, columnType, Optional.empty());
            ++columnIndex;
            builder.add((Object)columnHandle);
        }
        return builder.build();
    }

    public static List<HiveColumnHandle> getPartitionColumns(Schema schema, PartitionSpec spec, TypeManager typeManager) {
        ImmutableList partitionFields = ImmutableList.copyOf(IcebergUtil.getIdentityPartitions(spec).keySet());
        int columnIndex = 0;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PartitionField partitionField : partitionFields) {
            Type sourceType = schema.findType(partitionField.sourceId());
            Type type = partitionField.transform().getResultType(sourceType);
            io.prestosql.spi.type.Type prestoType = TypeConveter.toPrestoType(type, typeManager);
            HiveType hiveType = HiveType.toHiveType((TypeTranslator)TYPE_TRANSLATOR, (io.prestosql.spi.type.Type)IcebergUtil.coerceForHive(prestoType));
            HiveColumnHandle columnHandle = new HiveColumnHandle(partitionField.name(), hiveType, prestoType.getTypeSignature(), columnIndex, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
            ++columnIndex;
            builder.add((Object)columnHandle);
        }
        return builder.build();
    }

    public static io.prestosql.spi.type.Type coerceForHive(io.prestosql.spi.type.Type prestoType) {
        if (prestoType.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return TimestampType.TIMESTAMP;
        }
        return prestoType;
    }

    public static Map<PartitionField, Integer> getIdentityPartitions(PartitionSpec partitionSpec) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (int i = 0; i < partitionSpec.fields().size(); ++i) {
            PartitionField field = (PartitionField)partitionSpec.fields().get(i);
            if (!field.transform().toString().equals("identity")) continue;
            columns.put((Object)field, (Object)i);
        }
        return columns.build();
    }

    public static String getDataPath(String location) {
        if (!location.endsWith("/")) {
            location = location + "/";
        }
        return location + "data";
    }

    public static FileFormat getFileFormat(Table table) {
        return FileFormat.valueOf((String)table.properties().getOrDefault("write.format.default", "parquet").toUpperCase(Locale.ENGLISH));
    }

    public static TableScan getTableScan(ConnectorSession session, TupleDomain<HiveColumnHandle> predicates, Optional<Long> snapshotId, Table icebergTable) {
        Expression expression = ExpressionConverter.toIcebergExpression(predicates, session);
        TableScan tableScan = icebergTable.newScan().filter(expression);
        return snapshotId.map(id -> IcebergUtil.isSnapshot(icebergTable, id) ? tableScan.useSnapshot(id.longValue()) : tableScan.asOfTime(id.longValue())).orElse(tableScan);
    }

    private static boolean isSnapshot(Table icebergTable, Long id) {
        return Streams.stream((Iterable)icebergTable.snapshots()).anyMatch(snapshot -> snapshot.snapshotId() == id.longValue());
    }
}

