/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.iceberg.IcebergTableHandle;
import io.prestosql.plugin.iceberg.IcebergUtil;
import io.prestosql.plugin.iceberg.TypeConveter;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;

public class PartitionTable
implements SystemTable {
    private final IcebergTableHandle tableHandle;
    private final ConnectorSession session;
    private final TypeManager typeManager;
    private final Table icebergTable;
    private Map<Integer, Type.PrimitiveType> idToTypeMapping;
    private List<Types.NestedField> nonPartitionPrimitiveColumns;
    private List<io.prestosql.spi.type.Type> partitionColumnTypes;
    private List<io.prestosql.spi.type.Type> resultTypes;
    private List<RowType> columnMetricTypes;

    public PartitionTable(IcebergTableHandle tableHandle, ConnectorSession session, TypeManager typeManager, Table icebergTable) {
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        this.idToTypeMapping = this.icebergTable.schema().columns().stream().filter(column -> column.type().isPrimitiveType()).collect(Collectors.toMap(Types.NestedField::fieldId, column -> column.type().asPrimitiveType()));
        List columns = this.icebergTable.schema().columns();
        List partitionFields = this.icebergTable.spec().fields();
        ImmutableList.Builder columnMetadataBuilder = ImmutableList.builder();
        List<ColumnMetadata> partitionColumnsMetadata = this.getPartitionColumnsMetadata(partitionFields, this.icebergTable.schema());
        this.partitionColumnTypes = (List)partitionColumnsMetadata.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        columnMetadataBuilder.addAll(partitionColumnsMetadata);
        Set identityPartitionIds = IcebergUtil.getIdentityPartitions(this.icebergTable.spec()).keySet().stream().map(PartitionField::sourceId).collect(Collectors.toSet());
        this.nonPartitionPrimitiveColumns = (List)columns.stream().filter(column -> !identityPartitionIds.contains(column.fieldId()) && column.type().isPrimitiveType()).collect(ImmutableList.toImmutableList());
        ImmutableList.of((Object)"record_count", (Object)"file_count", (Object)"total_size").forEach(metric -> columnMetadataBuilder.add((Object)new ColumnMetadata(metric, (io.prestosql.spi.type.Type)BigintType.BIGINT)));
        List<ColumnMetadata> columnMetricsMetadata = this.getColumnMetadata(this.nonPartitionPrimitiveColumns);
        columnMetadataBuilder.addAll(columnMetricsMetadata);
        this.columnMetricTypes = (List)columnMetricsMetadata.stream().map(m -> (RowType)m.getType()).collect(ImmutableList.toImmutableList());
        ImmutableList columnMetadata = columnMetadataBuilder.build();
        this.resultTypes = (List)columnMetadata.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        return new ConnectorTableMetadata(this.tableHandle.getSchemaTableName(), (List)columnMetadata);
    }

    private List<ColumnMetadata> getPartitionColumnsMetadata(List<PartitionField> fields, Schema schema) {
        return (List)fields.stream().map(field -> new ColumnMetadata(field.name(), TypeConveter.toPrestoType(field.transform().getResultType(schema.findType(field.sourceId())), this.typeManager))).collect(ImmutableList.toImmutableList());
    }

    private List<ColumnMetadata> getColumnMetadata(List<Types.NestedField> columns) {
        return (List)columns.stream().map(column -> new ColumnMetadata(column.name(), (io.prestosql.spi.type.Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("min"), TypeConveter.toPrestoType(column.type(), this.typeManager)), (Object)new RowType.Field(Optional.of("max"), TypeConveter.toPrestoType(column.type(), this.typeManager)), (Object)new RowType.Field(Optional.of("nullCount"), (io.prestosql.spi.type.Type)BigintType.BIGINT))))).collect(ImmutableList.toImmutableList());
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            TableScan tableScan = this.getTableScan(constraint);
            Map<StructLikeWrapper, Partition> partitions = this.getPartitions(tableScan);
            RecordCursor recordCursor = this.buildRecordCursor(partitions, this.icebergTable.spec().fields());
            return recordCursor;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<StructLikeWrapper, Partition> getPartitions(TableScan tableScan) {
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            HashMap<StructLikeWrapper, Partition> partitions = new HashMap<StructLikeWrapper, Partition>();
            for (FileScanTask fileScanTask : fileScanTasks) {
                Partition partition;
                DataFile dataFile = fileScanTask.file();
                StructLike partitionStruct = dataFile.partition();
                StructLikeWrapper partitionWrapper = StructLikeWrapper.wrap((StructLike)partitionStruct);
                if (!partitions.containsKey(partitionWrapper)) {
                    partition = new Partition(partitionStruct, dataFile.recordCount(), dataFile.fileSizeInBytes(), this.toMap(dataFile.lowerBounds()), this.toMap(dataFile.upperBounds()), dataFile.nullValueCounts());
                    partitions.put(partitionWrapper, partition);
                    continue;
                }
                partition = (Partition)partitions.get(partitionWrapper);
                partition.incrementFileCount();
                partition.incrementRecordCount(dataFile.recordCount());
                partition.incrementSize(dataFile.fileSizeInBytes());
                partition.updateMin(this.toMap(dataFile.lowerBounds()), dataFile.nullValueCounts(), dataFile.recordCount());
                partition.updateMax(this.toMap(dataFile.upperBounds()), dataFile.nullValueCounts(), dataFile.recordCount());
                partition.updateNullCount(dataFile.nullValueCounts());
            }
            HashMap<StructLikeWrapper, Partition> hashMap = partitions;
            return hashMap;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private RecordCursor buildRecordCursor(Map<StructLikeWrapper, Partition> partitions, List<PartitionField> partitionFields) {
        List<Type> partitionTypes = this.partitionTypes(partitionFields);
        List partitionColumnClass = (List)partitionTypes.stream().map(type -> type.typeId().javaClass()).collect(ImmutableList.toImmutableList());
        int columnCounts = this.partitionColumnTypes.size() + 3 + this.columnMetricTypes.size();
        ImmutableList.Builder records = ImmutableList.builder();
        for (Partition partition : partitions.values()) {
            int i;
            ArrayList<Object> row = new ArrayList<Object>(columnCounts);
            for (i = 0; i < this.partitionColumnTypes.size(); ++i) {
                row.add(PartitionTable.convert(partition.getValues().get(i, (Class)partitionColumnClass.get(i)), partitionTypes.get(i)));
            }
            row.add(partition.getRecordCount());
            row.add(partition.getFileCount());
            row.add(partition.getSize());
            for (i = 0; i < this.columnMetricTypes.size(); ++i) {
                Integer fieldId = this.nonPartitionPrimitiveColumns.get(i).fieldId();
                Type.PrimitiveType type2 = this.idToTypeMapping.get(fieldId);
                Object min = PartitionTable.convert(partition.getMinValues().get(fieldId), (Type)type2);
                Object max = PartitionTable.convert(partition.getMaxValues().get(fieldId), (Type)type2);
                Long nullCount = partition.getNullCounts().get(fieldId);
                row.add(PartitionTable.getColumnMetricBlock(this.columnMetricTypes.get(i), min, max, nullCount));
            }
            records.add(row);
        }
        return new InMemoryRecordSet(this.resultTypes, (Iterable)records.build()).cursor();
    }

    private List<Type> partitionTypes(List<PartitionField> partitionFields) {
        ImmutableList.Builder partitionTypeBuilder = ImmutableList.builder();
        for (PartitionField partitionField : partitionFields) {
            Type.PrimitiveType sourceType = this.idToTypeMapping.get(partitionField.sourceId());
            Type type = partitionField.transform().getResultType((Type)sourceType);
            partitionTypeBuilder.add((Object)type);
        }
        return partitionTypeBuilder.build();
    }

    private static Block getColumnMetricBlock(RowType columnMetricType, Object min, Object max, Long nullCount) {
        BlockBuilder rowBlockBuilder = columnMetricType.createBlockBuilder(null, 1);
        BlockBuilder builder = rowBlockBuilder.beginBlockEntry();
        List fields = columnMetricType.getFields();
        TypeUtils.writeNativeValue((io.prestosql.spi.type.Type)((RowType.Field)fields.get(0)).getType(), (BlockBuilder)builder, (Object)min);
        TypeUtils.writeNativeValue((io.prestosql.spi.type.Type)((RowType.Field)fields.get(1)).getType(), (BlockBuilder)builder, (Object)max);
        TypeUtils.writeNativeValue((io.prestosql.spi.type.Type)((RowType.Field)fields.get(2)).getType(), (BlockBuilder)builder, (Object)nullCount);
        rowBlockBuilder.closeEntry();
        return columnMetricType.getObject((Block)rowBlockBuilder, 0);
    }

    private TableScan getTableScan(TupleDomain<Integer> constraint) {
        List<HiveColumnHandle> partitionColumns = IcebergUtil.getPartitionColumns(this.icebergTable.schema(), this.icebergTable.spec(), this.typeManager);
        Map fieldIdToColumnHandle = IntStream.range(0, this.partitionColumnTypes.size()).boxed().collect(Collectors.toMap(Function.identity(), partitionColumns::get));
        TupleDomain predicates = constraint.transform(fieldIdToColumnHandle::get);
        return IcebergUtil.getTableScan(this.session, (TupleDomain<HiveColumnHandle>)predicates, this.tableHandle.getSnapshotId(), this.icebergTable);
    }

    private Map<Integer, Object> toMap(Map<Integer, ByteBuffer> idToMetricMap) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        idToMetricMap.forEach((id, value) -> {
            Type.PrimitiveType type = this.idToTypeMapping.get(id);
            map.put(id, Conversions.fromByteBuffer((Type)type, (ByteBuffer)value));
        });
        return map.build();
    }

    private static Object convert(Object value, Type type) {
        if (value == null) {
            return null;
        }
        if (type instanceof Types.StringType) {
            return value.toString();
        }
        if (type instanceof Types.BinaryType) {
            return ((ByteBuffer)value).array();
        }
        if (type instanceof Types.TimestampType) {
            long utcMillis = TimeUnit.MICROSECONDS.toMillis((Long)value);
            Types.TimestampType timestampType = (Types.TimestampType)type;
            if (timestampType.shouldAdjustToUTC()) {
                return DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY);
            }
            return utcMillis;
        }
        if (type instanceof Types.FloatType) {
            return Float.floatToIntBits(((Float)value).floatValue());
        }
        return value;
    }

    private class Partition {
        private final StructLike values;
        private long recordCount;
        private long fileCount;
        private long size;
        private final Map<Integer, Object> minValues;
        private final Map<Integer, Object> maxValues;
        private final Map<Integer, Long> nullCounts;
        private final Set<Integer> corruptedStats;

        public Partition(StructLike values, long recordCount, long size, Map<Integer, Object> minValues, Map<Integer, Object> maxValues, Map<Integer, Long> nullCounts) {
            this.values = Objects.requireNonNull(values, "values is null");
            this.recordCount = recordCount;
            this.fileCount = 1L;
            this.size = size;
            this.minValues = ImmutableMap.copyOf(Objects.requireNonNull(minValues, "minValues is null"));
            this.maxValues = ImmutableMap.copyOf(Objects.requireNonNull(maxValues, "maxValues is null"));
            this.corruptedStats = PartitionTable.this.nonPartitionPrimitiveColumns.stream().map(Types.NestedField::fieldId).filter(id -> !minValues.containsKey(id) && (!nullCounts.containsKey(id) || (Long)nullCounts.get(id) != recordCount)).collect(Collectors.toCollection(HashSet::new));
            this.nullCounts = new HashMap<Integer, Long>(nullCounts);
        }

        public StructLike getValues() {
            return this.values;
        }

        public long getRecordCount() {
            return this.recordCount;
        }

        public long getFileCount() {
            return this.fileCount;
        }

        public long getSize() {
            return this.size;
        }

        public Map<Integer, Object> getMinValues() {
            return this.minValues;
        }

        public Map<Integer, Object> getMaxValues() {
            return this.maxValues;
        }

        public Map<Integer, Long> getNullCounts() {
            return this.nullCounts;
        }

        public void incrementRecordCount(long count) {
            this.recordCount += count;
        }

        public void incrementFileCount() {
            ++this.fileCount;
        }

        public void incrementSize(long numberOfBytes) {
            this.size += numberOfBytes;
        }

        public void updateMin(Map<Integer, Object> lowerBounds, Map<Integer, Long> nullCounts, long recordCount) {
            this.updateStats(this.minValues, lowerBounds, nullCounts, recordCount, i -> i > 0);
        }

        public void updateMax(Map<Integer, Object> upperBounds, Map<Integer, Long> nullCounts, long recordCount) {
            this.updateStats(this.maxValues, upperBounds, nullCounts, recordCount, i -> i < 0);
        }

        private void updateStats(Map<Integer, Object> current, Map<Integer, Object> newStat, Map<Integer, Long> nullCounts, long recordCount, Predicate<Integer> predicate) {
            for (Types.NestedField column : PartitionTable.this.nonPartitionPrimitiveColumns) {
                Comparator comparator;
                int id = column.fieldId();
                if (this.corruptedStats.contains(id)) continue;
                Object newValue = newStat.get(id);
                if (newValue == null) {
                    Long nullCount = nullCounts.get(id);
                    if (nullCount != null && nullCount == recordCount) continue;
                    current.remove(id);
                    this.corruptedStats.add(id);
                    continue;
                }
                Object oldValue = current.putIfAbsent(id, newValue);
                if (oldValue == null || !predicate.test((comparator = Comparators.forType((Type.PrimitiveType)((Type.PrimitiveType)PartitionTable.this.idToTypeMapping.get(id)))).compare(oldValue, newValue))) continue;
                current.put(id, newValue);
            }
        }

        public void updateNullCount(Map<Integer, Long> nullCounts) {
            nullCounts.forEach((key, counts) -> this.nullCounts.merge((Integer)key, (Long)counts, Long::sum));
        }
    }
}

