/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class TypeConveter {
    private static final Map<Class<? extends io.prestosql.spi.type.Type>, Type> PRESTO_TO_ICEBERG = ImmutableMap.builder().put(BooleanType.class, (Object)Types.BooleanType.get()).put(VarbinaryType.class, (Object)Types.BinaryType.get()).put(DateType.class, (Object)Types.DateType.get()).put(DoubleType.class, (Object)Types.DoubleType.get()).put(BigintType.class, (Object)Types.LongType.get()).put(RealType.class, (Object)Types.FloatType.get()).put(IntegerType.class, (Object)Types.IntegerType.get()).put(TimeType.class, (Object)Types.TimeType.get()).put(TimestampType.class, (Object)Types.TimestampType.withoutZone()).put(TimestampWithTimeZoneType.class, (Object)Types.TimestampType.withZone()).put(VarcharType.class, (Object)Types.StringType.get()).build();

    private TypeConveter() {
    }

    public static io.prestosql.spi.type.Type toPrestoType(Type type, TypeManager typeManager) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BINARY: 
            case FIXED: {
                return VarbinaryType.VARBINARY;
            }
            case DATE: {
                return DateType.DATE;
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return DecimalType.createDecimalType((int)decimalType.precision(), (int)decimalType.scale());
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case INTEGER: {
                return IntegerType.INTEGER;
            }
            case TIME: {
                return TimeType.TIME;
            }
            case TIMESTAMP: {
                Types.TimestampType timestampType = (Types.TimestampType)type;
                if (timestampType.shouldAdjustToUTC()) {
                    return TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
                }
                return TimestampType.TIMESTAMP;
            }
            case UUID: 
            case STRING: {
                return VarcharType.createUnboundedVarcharType();
            }
            case LIST: {
                Types.ListType listType = (Types.ListType)type;
                return new ArrayType(TypeConveter.toPrestoType(listType.elementType(), typeManager));
            }
            case MAP: {
                Types.MapType mapType = (Types.MapType)type;
                TypeSignature keyType = TypeConveter.toPrestoType(mapType.keyType(), typeManager).getTypeSignature();
                TypeSignature valueType = TypeConveter.toPrestoType(mapType.valueType(), typeManager).getTypeSignature();
                return typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType), (Object)TypeSignatureParameter.of((TypeSignature)valueType)));
            }
            case STRUCT: {
                List fields = ((Types.StructType)type).fields();
                return RowType.from((List)((List)fields.stream().map(field -> new RowType.Field(Optional.of(field.name()), TypeConveter.toPrestoType(field.type(), typeManager))).collect(ImmutableList.toImmutableList())));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot convert from Iceberg type '%s' (%s) to Presto type", type, type.typeId()));
    }

    public static Type toIcebergType(io.prestosql.spi.type.Type type) {
        if (PRESTO_TO_ICEBERG.containsKey(type.getClass())) {
            return PRESTO_TO_ICEBERG.get(type.getClass());
        }
        if (type instanceof DecimalType) {
            return TypeConveter.fromDecimal((DecimalType)type);
        }
        if (type instanceof RowType) {
            return TypeConveter.fromRow((RowType)type);
        }
        if (type instanceof ArrayType) {
            return TypeConveter.fromArray((ArrayType)type);
        }
        if (type instanceof MapType) {
            return TypeConveter.fromMap((MapType)type);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Type not supported for Iceberg: " + type.getDisplayName());
    }

    private static Type fromDecimal(DecimalType type) {
        return Types.DecimalType.of((int)type.getPrecision(), (int)type.getScale());
    }

    private static Type fromRow(RowType type) {
        ArrayList<Types.NestedField> fields = new ArrayList<Types.NestedField>();
        for (RowType.Field field : type.getFields()) {
            String name = (String)field.getName().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Row type field does not have a name: " + type.getDisplayName()));
            fields.add(Types.NestedField.required((int)(fields.size() + 1), (String)name, (Type)TypeConveter.toIcebergType(field.getType())));
        }
        return Types.StructType.of(fields);
    }

    private static Type fromArray(ArrayType type) {
        return Types.ListType.ofOptional((int)1, (Type)TypeConveter.toIcebergType(type.getElementType()));
    }

    private static Type fromMap(MapType type) {
        return Types.MapType.ofOptional((int)1, (int)2, (Type)TypeConveter.toIcebergType(type.getKeyType()), (Type)TypeConveter.toIcebergType(type.getValueType()));
    }
}

