/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.iceberg;

import io.prestosql.plugin.iceberg.IcebergErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Objects;

public class UnknownTableTypeException
extends PrestoException {
    private final SchemaTableName tableName;

    public UnknownTableTypeException(SchemaTableName tableName) {
        super((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_UNKNOWN_TABLE_TYPE, "Not an Iceberg table: " + tableName);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }
}

