/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.plugin.base.JsonUtils;
import io.prestosql.plugin.base.security.CatalogAccessControlRule;
import io.prestosql.plugin.base.security.FileBasedSystemAccessControlRules;
import io.prestosql.plugin.base.security.ForwardingSystemAccessControl;
import io.prestosql.plugin.base.security.PrincipalUserMatchRule;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.SystemAccessControlFactory;
import io.prestosql.spi.security.SystemSecurityContext;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class FileBasedSystemAccessControl
implements SystemAccessControl {
    private static final Logger log = Logger.get(FileBasedSystemAccessControl.class);
    public static final String NAME = "file";
    private final List<CatalogAccessControlRule> catalogRules;
    private final Optional<List<PrincipalUserMatchRule>> principalUserMatchRules;

    private FileBasedSystemAccessControl(List<CatalogAccessControlRule> catalogRules, Optional<List<PrincipalUserMatchRule>> principalUserMatchRules) {
        this.catalogRules = catalogRules;
        this.principalUserMatchRules = principalUserMatchRules;
    }

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(userName, "userName is null");
        if (!this.principalUserMatchRules.isPresent()) {
            return;
        }
        if (!principal.isPresent()) {
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        String principalName = principal.get().getName();
        for (PrincipalUserMatchRule rule : this.principalUserMatchRules.get()) {
            Optional<Boolean> allowed = rule.match(principalName, userName);
            if (!allowed.isPresent()) continue;
            if (allowed.get().booleanValue()) {
                return;
            }
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        AccessDeniedException.denySetUser(principal, (String)userName);
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        if (!this.canAccessCatalog(context.getIdentity(), catalogName)) {
            AccessDeniedException.denyCatalogAccess((String)catalogName);
        }
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        ImmutableSet.Builder filteredCatalogs = ImmutableSet.builder();
        for (String catalog : catalogs) {
            if (!this.canAccessCatalog(context.getIdentity(), catalog)) continue;
            filteredCatalogs.add((Object)catalog);
        }
        return filteredCatalogs.build();
    }

    private boolean canAccessCatalog(Identity identity, String catalogName) {
        for (CatalogAccessControlRule rule : this.catalogRules) {
            Optional<Boolean> allowed = rule.match(identity.getUser(), catalogName);
            if (!allowed.isPresent()) continue;
            return allowed.get();
        }
        return false;
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
    }

    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        if (!this.canAccessCatalog(context.getIdentity(), catalogName)) {
            return ImmutableSet.of();
        }
        return schemaNames;
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public void checkCanShowTablesMetadata(SystemSecurityContext context, CatalogSchemaName schema) {
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        if (!this.canAccessCatalog(context.getIdentity(), catalogName)) {
            return ImmutableSet.of();
        }
        return tableNames;
    }

    public void checkCanShowColumnsMetadata(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public List<ColumnMetadata> filterColumns(SystemSecurityContext context, CatalogSchemaTableName tableName, List<ColumnMetadata> columns) {
        if (!this.canAccessCatalog(context.getIdentity(), tableName.getCatalogName())) {
            return ImmutableList.of();
        }
        return columns;
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
    }

    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean withGrantOption) {
    }

    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOptionFor) {
    }

    public void checkCanShowRoles(SystemSecurityContext context, String catalogName) {
    }

    public static class Factory
    implements SystemAccessControlFactory {
        public String getName() {
            return FileBasedSystemAccessControl.NAME;
        }

        public SystemAccessControl create(Map<String, String> config) {
            Objects.requireNonNull(config, "config is null");
            String configFileName = config.get("security.config-file");
            Preconditions.checkState((configFileName != null ? 1 : 0) != 0, (String)"Security configuration must contain the '%s' property", (Object)"security.config-file");
            if (config.containsKey("security.refresh-period")) {
                Duration refreshPeriod;
                try {
                    refreshPeriod = Duration.valueOf((String)config.get("security.refresh-period"));
                }
                catch (IllegalArgumentException e) {
                    throw this.invalidRefreshPeriodException(config, configFileName);
                }
                if (refreshPeriod.toMillis() == 0L) {
                    throw this.invalidRefreshPeriodException(config, configFileName);
                }
                return ForwardingSystemAccessControl.of((Supplier<SystemAccessControl>)Suppliers.memoizeWithExpiration(() -> {
                    log.info("Refreshing system access control from %s", new Object[]{configFileName});
                    return this.create(configFileName);
                }, (long)refreshPeriod.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
            return this.create(configFileName);
        }

        private PrestoException invalidRefreshPeriodException(Map<String, String> config, String configFileName) {
            return new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, String.format("Invalid duration value '%s' for property '%s' in '%s'", config.get("security.refresh-period"), "security.refresh-period", configFileName));
        }

        private SystemAccessControl create(String configFileName) {
            FileBasedSystemAccessControlRules rules = JsonUtils.parseJson(Paths.get(configFileName, new String[0]), FileBasedSystemAccessControlRules.class);
            ImmutableList.Builder catalogRulesBuilder = ImmutableList.builder();
            catalogRulesBuilder.addAll(rules.getCatalogRules());
            catalogRulesBuilder.add((Object)new CatalogAccessControlRule(true, Optional.of(Pattern.compile(".*")), Optional.of(Pattern.compile("system"))));
            return new FileBasedSystemAccessControl((List)catalogRulesBuilder.build(), rules.getPrincipalUserMatchRules());
        }
    }
}

