/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.hive.HiveCatalog;

public final class HiveCatalogs {
    private static final Cache<String, HiveCatalog> CATALOG_CACHE = Caffeine.newBuilder().weakValues().build();

    private HiveCatalogs() {
    }

    public static HiveCatalog loadCatalog(Configuration conf) {
        String metastoreUri = conf.get(HiveConf.ConfVars.METASTOREURIS.varname, "");
        return (HiveCatalog)CATALOG_CACHE.get((Object)metastoreUri, uri -> new HiveCatalog(conf));
    }
}

