/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.hive.HiveTypeConverter;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableOperations.class);
    private final HiveClientPool metaClients;
    private final String database;
    private final String tableName;

    protected HiveTableOperations(Configuration conf, HiveClientPool metaClients, String database, String table) {
        super(conf);
        this.metaClients = metaClients;
        this.database = database;
        this.tableName = table;
    }

    public TableMetadata refresh() {
        String metadataLocation = null;
        try {
            Table table = this.metaClients.run(client -> client.getTable(this.database, this.tableName));
            String tableType = (String)table.getParameters().get("table_type");
            if (tableType == null || !tableType.equalsIgnoreCase("iceberg")) {
                throw new IllegalArgumentException(String.format("Invalid tableName, not Iceberg: %s.%s", this.database, table));
            }
            metadataLocation = (String)table.getParameters().get("metadata_location");
            if (metadataLocation == null) {
                String errMsg = String.format("%s.%s is missing %s property", this.database, this.tableName, "metadata_location");
                throw new IllegalArgumentException(errMsg);
            }
        }
        catch (NoSuchObjectException e) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchTableException(String.format("No such table: %s.%s", this.database, this.tableName), new Object[0]);
            }
        }
        catch (TException e) {
            String errMsg = String.format("Failed to get table info from metastore %s.%s", this.database, this.tableName);
            throw new RuntimeException(errMsg, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during refresh", e);
        }
        this.refreshFromMetadataLocation(metadataLocation);
        return this.current();
    }

    public void commit(TableMetadata base, TableMetadata metadata) {
        if (base != this.current()) {
            throw new CommitFailedException("Cannot commit: stale table metadata for %s.%s", new Object[]{this.database, this.tableName});
        }
        if (base == metadata) {
            LOG.info("Nothing to commit.");
            return;
        }
        String newMetadataLocation = this.writeNewMetadata(metadata, this.currentVersion() + 1);
        boolean threw = true;
        Optional<Long> lockId = Optional.empty();
        try {
            Table tbl;
            lockId = Optional.of(this.acquireLock());
            if (base != null) {
                tbl = this.metaClients.run(client -> client.getTable(this.database, this.tableName));
            } else {
                long currentTimeMillis = System.currentTimeMillis();
                tbl = new Table(this.tableName, this.database, System.getProperty("user.name"), (int)currentTimeMillis / 1000, (int)currentTimeMillis / 1000, Integer.MAX_VALUE, this.storageDescriptor(metadata), Collections.emptyList(), new HashMap(), null, null, TableType.EXTERNAL_TABLE.toString());
                tbl.getParameters().put("EXTERNAL", "TRUE");
            }
            tbl.setSd(this.storageDescriptor(metadata));
            String metadataLocation = (String)tbl.getParameters().get("metadata_location");
            if (!Objects.equals(this.currentMetadataLocation(), metadataLocation)) {
                String errMsg = String.format("metadataLocation = %s is not same as table metadataLocation %s for %s.%s", this.currentMetadataLocation(), metadataLocation, this.database, this.tableName);
                throw new CommitFailedException(errMsg, new Object[0]);
            }
            this.setParameters(newMetadataLocation, tbl);
            if (base != null) {
                this.metaClients.run(client -> {
                    client.alter_table(this.database, this.tableName, tbl);
                    return null;
                });
            } else {
                this.metaClients.run(client -> {
                    client.createTable(tbl);
                    return null;
                });
            }
            threw = false;
        }
        catch (UnknownHostException | TException e) {
            throw new RuntimeException(String.format("Metastore operation failed for %s.%s", this.database, this.tableName), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during commit", e);
        }
        finally {
            if (threw) {
                this.io().deleteFile(newMetadataLocation);
            }
            this.unlock(lockId);
        }
        this.requestRefresh();
    }

    private void setParameters(String newMetadataLocation, Table tbl) {
        HashMap<String, String> parameters = tbl.getParameters();
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        parameters.put("table_type", "iceberg".toUpperCase(Locale.ENGLISH));
        parameters.put("metadata_location", newMetadataLocation);
        if (this.currentMetadataLocation() != null && !this.currentMetadataLocation().isEmpty()) {
            parameters.put("previous_metadata_location", this.currentMetadataLocation());
        }
        tbl.setParameters(parameters);
    }

    private StorageDescriptor storageDescriptor(TableMetadata metadata) {
        StorageDescriptor storageDescriptor = new StorageDescriptor();
        storageDescriptor.setCols(this.columns(metadata.schema()));
        storageDescriptor.setLocation(metadata.location());
        storageDescriptor.setOutputFormat("org.apache.hadoop.mapred.FileOutputFormat");
        storageDescriptor.setInputFormat("org.apache.hadoop.mapred.FileInputFormat");
        SerDeInfo serDeInfo = new SerDeInfo();
        serDeInfo.setSerializationLib("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
        storageDescriptor.setSerdeInfo(serDeInfo);
        return storageDescriptor;
    }

    private List<FieldSchema> columns(Schema schema) {
        return schema.columns().stream().map(col -> new FieldSchema(col.name(), HiveTypeConverter.convert(col.type()), "")).collect(Collectors.toList());
    }

    private long acquireLock() throws UnknownHostException, TException, InterruptedException {
        LockComponent lockComponent = new LockComponent(LockType.EXCLUSIVE, LockLevel.TABLE, this.database);
        lockComponent.setTablename(this.tableName);
        LockRequest lockRequest = new LockRequest((List)Lists.newArrayList((Object[])new LockComponent[]{lockComponent}), System.getProperty("user.name"), InetAddress.getLocalHost().getHostName());
        LockResponse lockResponse = this.metaClients.run(client -> client.lock(lockRequest));
        LockState state = lockResponse.getState();
        long lockId = lockResponse.getLockid();
        while (state.equals((Object)LockState.WAITING)) {
            lockResponse = this.metaClients.run(client -> client.checkLock(lockId));
            state = lockResponse.getState();
        }
        if (!state.equals((Object)LockState.ACQUIRED)) {
            throw new CommitFailedException(String.format("Could not acquire the lock on %s.%s, lock request ended in state %s", this.database, this.tableName, state), new Object[0]);
        }
        return lockId;
    }

    private void unlock(Optional<Long> lockId) {
        if (lockId.isPresent()) {
            try {
                this.metaClients.run(client -> {
                    client.unlock(((Long)lockId.get()).longValue());
                    return null;
                });
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to unlock %s.%s", this.database, this.tableName), e);
            }
        }
    }
}

