/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.stream.Collectors;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public final class HiveTypeConverter {
    private HiveTypeConverter() {
    }

    public static String convert(Type type) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return "boolean";
            }
            case INTEGER: {
                return "int";
            }
            case LONG: {
                return "bigint";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                throw new UnsupportedOperationException("Hive does not support time fields");
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case STRING: 
            case UUID: {
                return "string";
            }
            case FIXED: {
                return "binary";
            }
            case BINARY: {
                return "binary";
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return String.format("decimal(%s,%s)", decimalType.precision(), decimalType.scale());
            }
            case STRUCT: {
                Types.StructType structType = type.asStructType();
                String nameToType = structType.fields().stream().map(f -> String.format("%s:%s", f.name(), HiveTypeConverter.convert(f.type()))).collect(Collectors.joining(","));
                return String.format("struct<%s>", nameToType);
            }
            case LIST: {
                Types.ListType listType = type.asListType();
                return String.format("array<%s>", HiveTypeConverter.convert(listType.elementType()));
            }
            case MAP: {
                Types.MapType mapType = type.asMapType();
                return String.format("map<%s,%s>", HiveTypeConverter.convert(mapType.keyType()), HiveTypeConverter.convert(mapType.valueType()));
            }
        }
        throw new UnsupportedOperationException(type + " is not supported");
    }
}

