/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.SubStream;
import java.io.InputStream;
import java.util.Iterator;

public final class SubStreamGenerator
implements Iterable<InputStream> {
    private final Object mutex = new Object();
    private final long blockSize;
    private final InputStream wrappedStream;
    private int currentBlock = 0;
    private long lastBlockSize;
    private int blocksPending;

    public SubStreamGenerator(InputStream wrappedStream, int totalBlocks, long blockSize) {
        this.wrappedStream = wrappedStream;
        this.blocksPending = totalBlocks;
        this.blockSize = blockSize;
        this.lastBlockSize = blockSize;
    }

    public void setLastBlockSize(long blockSize) {
        this.lastBlockSize = blockSize;
    }

    @Override
    public Iterator<InputStream> iterator() {
        return new SubStreamIterator();
    }

    private class SubStreamIterator
    implements Iterator<InputStream> {
        private SubStreamIterator() {
        }

        @Override
        public boolean hasNext() {
            return SubStreamGenerator.this.blocksPending > 0;
        }

        @Override
        public SubStream next() {
            SubStreamGenerator.this.blocksPending--;
            return new SubStream(SubStreamGenerator.this.wrappedStream, (long)SubStreamGenerator.this.currentBlock++ * SubStreamGenerator.this.blockSize, SubStreamGenerator.this.blocksPending > 0 ? SubStreamGenerator.this.blockSize : SubStreamGenerator.this.lastBlockSize, SubStreamGenerator.this.mutex);
        }

        @Override
        public void remove() {
        }
    }
}

