/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core;

import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonParseException;
import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonParser;
import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public final class JsonUtilities {
    public static void assertIsExpectedFieldName(JsonParser parser, String expectedValue) throws JsonParseException, IOException {
        String actualValue = parser.getCurrentName();
        if (expectedValue == null ? actualValue != null : !expectedValue.equals(actualValue)) {
            throw new JsonParseException(String.format("Unexpected field name. Expected: '%s'. Actual: '%s'.", expectedValue, actualValue), parser.getCurrentLocation());
        }
    }

    public static void assertIsFieldNameJsonToken(JsonParser parser) throws JsonParseException {
        if (parser.getCurrentToken() != JsonToken.FIELD_NAME) {
            throw new JsonParseException("Expected a field name.", parser.getCurrentLocation());
        }
    }

    public static void assertIsStartObjectJsonToken(JsonParser parser) throws JsonParseException {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("Expected the start of a JSON Object.", parser.getCurrentLocation());
        }
    }

    public static void assertIsEndObjectJsonToken(JsonParser parser) throws JsonParseException {
        if (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            throw new JsonParseException("Expected the end of a JSON Object.", parser.getCurrentLocation());
        }
    }

    public static void assertIsStartArrayJsonToken(JsonParser parser) throws JsonParseException {
        if (parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new JsonParseException("Expected the start of a JSON Array.", parser.getCurrentLocation());
        }
    }

    public static void assertIsEndArrayJsonToken(JsonParser parser) throws JsonParseException {
        if (parser.getCurrentToken() != JsonToken.END_ARRAY) {
            throw new JsonParseException("Expected the end of a JSON Array.", parser.getCurrentLocation());
        }
    }
}

