/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table;

import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonGenerationException;
import io.prestosql.hadoop.$internal.com.fasterxml.jackson.core.JsonGenerator;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.EdmType;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.EntityProperty;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.TableEntity;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.TableRequestOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

final class TableEntitySerializer {
    TableEntitySerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeSingleEntityToStream(OutputStream outStream, TableRequestOptions options, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws StorageException, IOException {
        JsonGenerator generator = Utility.getJsonGenerator(outStream);
        try {
            TableEntitySerializer.writeJsonEntity(generator, options, entity, isTableEntry, opContext);
        }
        finally {
            generator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeSingleEntityToString(StringWriter strWriter, TableRequestOptions options, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws StorageException, IOException {
        JsonGenerator generator = Utility.getJsonGenerator(strWriter);
        try {
            TableEntitySerializer.writeJsonEntity(generator, options, entity, isTableEntry, opContext);
        }
        finally {
            generator.close();
        }
    }

    private static void writeJsonEntity(JsonGenerator generator, TableRequestOptions options, TableEntity entity, boolean isTableEntry, OperationContext opContext) throws StorageException, IOException {
        Map<String, EntityProperty> properties = TableEntitySerializer.getPropertiesFromDictionary(entity, options, opContext);
        generator.writeStartObject();
        if (!isTableEntry) {
            Utility.assertNotNull("PartitionKey", entity.getPartitionKey());
            Utility.assertNotNull("RowKey", entity.getRowKey());
            Utility.assertNotNull("Timestamp", entity.getTimestamp());
            generator.writeStringField("PartitionKey", entity.getPartitionKey());
            generator.writeStringField("RowKey", entity.getRowKey());
            generator.writeStringField("Timestamp", Utility.getJavaISO8601Time(entity.getTimestamp()));
        }
        for (Map.Entry<String, EntityProperty> ent : properties.entrySet()) {
            String edmTypeString;
            if (ent.getKey().equals("PartitionKey") || ent.getKey().equals("RowKey") || ent.getKey().equals("Timestamp") || ent.getKey().equals("Etag")) continue;
            EntityProperty currProp = ent.getValue();
            if (currProp.getEdmType().mustAnnotateType()) {
                edmTypeString = currProp.getEdmType().toString();
                generator.writeStringField(ent.getKey() + "@odata.type", edmTypeString);
                generator.writeStringField(ent.getKey(), ent.getValue().getValueAsString());
                continue;
            }
            if (currProp.getEdmType() == EdmType.DOUBLE && !currProp.getIsNull()) {
                edmTypeString = currProp.getEdmType().toString();
                Double value = currProp.getValueAsDouble();
                if (value.equals(Double.POSITIVE_INFINITY) || value.equals(Double.NEGATIVE_INFINITY) || value.equals(Double.NaN)) {
                    generator.writeStringField(ent.getKey() + "@odata.type", edmTypeString);
                    generator.writeStringField(ent.getKey(), ent.getValue().getValueAsString());
                    continue;
                }
                TableEntitySerializer.writeJsonProperty(generator, ent);
                continue;
            }
            TableEntitySerializer.writeJsonProperty(generator, ent);
        }
        generator.writeEndObject();
    }

    private static void writeJsonProperty(JsonGenerator generator, Map.Entry<String, EntityProperty> prop) throws JsonGenerationException, IOException {
        EdmType edmType = prop.getValue().getEdmType();
        if (prop.getValue().getIsNull()) {
            generator.writeNullField(prop.getKey());
        } else if (edmType == EdmType.BOOLEAN) {
            generator.writeBooleanField(prop.getKey(), prop.getValue().getValueAsBoolean());
        } else if (edmType == EdmType.DOUBLE) {
            generator.writeNumberField(prop.getKey(), prop.getValue().getValueAsDouble());
        } else if (edmType == EdmType.INT32) {
            generator.writeNumberField(prop.getKey(), prop.getValue().getValueAsInteger());
        } else {
            generator.writeStringField(prop.getKey(), prop.getValue().getValueAsString());
        }
    }

    private static Map<String, EntityProperty> getPropertiesFromDictionary(TableEntity entity, TableRequestOptions options, OperationContext opContext) throws IOException, StorageException {
        Map<String, EntityProperty> properties = entity.writeEntity(opContext);
        if (properties == null) {
            properties = new HashMap();
        }
        options.assertPolicyIfRequired();
        if (options.getEncryptionPolicy() != null) {
            properties = options.getEncryptionPolicy().encryptEntity(properties, entity.getPartitionKey(), entity.getRowKey(), options.getEncryptionResolver());
        }
        return properties;
    }
}

