/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type;

import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.UniversalTag;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.parse.Asn1ParseResult;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type.Asn1Simple;
import java.io.IOException;

public class Asn1BmpString
extends Asn1Simple<String> {
    public Asn1BmpString() {
        super(UniversalTag.BMP_STRING);
    }

    public Asn1BmpString(String value) {
        super(UniversalTag.BMP_STRING, value);
    }

    @Override
    protected int encodingBodyLength() {
        return ((String)this.getValue()).length() * 2;
    }

    @Override
    protected void toBytes() {
        String strValue = (String)this.getValue();
        int len = strValue.length();
        byte[] bytes = new byte[len * 2];
        for (int i = 0; i != len; ++i) {
            char c = strValue.charAt(i);
            bytes[2 * i] = (byte)(c >> 8);
            bytes[2 * i + 1] = (byte)c;
        }
        this.setBytes(bytes);
    }

    @Override
    protected void toValue() throws IOException {
        byte[] bytes = this.getBytes();
        char[] chars = new char[bytes.length / 2];
        for (int i = 0; i != chars.length; ++i) {
            chars[i] = (char)(bytes[2 * i] << 8 | bytes[2 * i + 1] & 0xFF);
        }
        this.setValue(new String(chars));
    }

    @Override
    protected void decodeBody(Asn1ParseResult parseResult) throws IOException {
        if (parseResult.getBodyLength() % 2 != 0) {
            throw new IOException("Bad stream, BMP string expecting multiple of 2 bytes");
        }
        super.decodeBody(parseResult);
    }
}

