/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command;

import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminClient;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.remote.command.RemoteCommand;
import java.io.Console;
import java.util.Scanner;

public class RemoteDeletePrincipalCommand
extends RemoteCommand {
    public static final String USAGE = "Usage: delete_principal <principal-name>\n\tExample:\n\t\tdelete_principal alice\n";

    public RemoteDeletePrincipalCommand(AdminClient adminClient) {
        super(adminClient);
    }

    @Override
    public void execute(String input) throws KrbException {
        String reply;
        String[] items = input.split("\\s+");
        if (items.length < 2) {
            System.err.println(USAGE);
            return;
        }
        String principal = items[items.length - 1] + "@" + this.adminClient.getAdminConfig().getAdminRealm();
        Console console = System.console();
        String prompt = "Are you sure to delete the principal? (yes/no, YES/NO, y/n, Y/N) ";
        if (console == null) {
            System.out.println("Couldn't get Console instance, maybe you're running this from within an IDE. Use scanner to read password.");
            Scanner scanner = new Scanner(System.in, "UTF-8");
            reply = this.getReply(scanner, prompt);
        } else {
            reply = this.getReply(console, prompt);
        }
        if (reply.equals("yes") || reply.equals("YES") || reply.equals("y") || reply.equals("Y")) {
            this.adminClient.requestDeletePrincipal(principal);
        } else if (reply.equals("no") || reply.equals("NO") || reply.equals("n") || reply.equals("N")) {
            System.out.println("Principal \"" + principal + "\"  not deleted.");
        } else {
            System.err.println("Unknown request, fail to delete the principal.");
            System.err.println(USAGE);
        }
    }

    private String getReply(Scanner scanner, String prompt) {
        System.out.println(prompt);
        return scanner.nextLine().trim();
    }

    private String getReply(Console console, String prompt) {
        console.printf(prompt, new Object[0]);
        String line = console.readLine();
        return line;
    }
}

