/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.impl;

import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.KdcContext;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.KdcSetting;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.KdcUtil;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.impl.AbstractInternalKdcServer;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.impl.DefaultKdcHandler;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.preauth.PreauthHandler;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.transport.KdcNetwork;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.transport.TransportPair;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class DefaultInternalKdcServerImpl
extends AbstractInternalKdcServer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInternalKdcServerImpl.class);
    private ExecutorService executor;
    private KdcContext kdcContext;
    private KdcNetwork network;

    public DefaultInternalKdcServerImpl(KdcSetting kdcSetting) {
        super(kdcSetting);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.prepareHandler();
        this.executor = Executors.newCachedThreadPool();
        this.network = new KdcNetwork(){

            @Override
            protected void onNewTransport(KrbTransport transport) {
                DefaultKdcHandler kdcHandler = new DefaultKdcHandler(DefaultInternalKdcServerImpl.this.kdcContext, transport);
                DefaultInternalKdcServerImpl.this.executor.execute(kdcHandler);
            }
        };
        this.network.init();
        TransportPair tpair = KdcUtil.getTransportPair(this.getSetting());
        this.network.listen(tpair);
        this.network.start();
    }

    private void prepareHandler() {
        this.kdcContext = new KdcContext(this.getSetting());
        this.kdcContext.setIdentityService(this.getIdentityService());
        PreauthHandler preauthHandler = new PreauthHandler();
        preauthHandler.init();
        this.kdcContext.setPreauthHandler(preauthHandler);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.network != null) {
            this.network.stop();
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                boolean terminated = false;
                while (!(terminated = this.executor.awaitTermination(60L, TimeUnit.SECONDS))) {
                }
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                LOG.warn("waitForTermination interrupted");
            }
        }
        LOG.info("Default Internal kdc server stopped.");
    }
}

