/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad;

import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.Asn1FieldInfo;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.EnumType;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.ExplicitField;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type.Asn1Integer;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type.Asn1OctetString;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type.Asn1Type;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.KrbSequenceType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationType;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;

public class AuthorizationDataEntry
extends KrbSequenceType {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationDataEntry.class);
    private static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField(AuthorizationDataEntryField.AD_TYPE, Asn1Integer.class), new ExplicitField(AuthorizationDataEntryField.AD_DATA, Asn1OctetString.class)};

    public AuthorizationDataEntry() {
        super(fieldInfos);
    }

    public AuthorizationDataEntry(AuthorizationType type) {
        super(fieldInfos);
        this.setAuthzType(type);
    }

    public AuthorizationDataEntry(AuthorizationType type, byte[] authzData) {
        super(fieldInfos);
        this.setAuthzType(type);
        this.setAuthzData(authzData);
    }

    public AuthorizationType getAuthzType() {
        Integer value = this.getFieldAsInteger(AuthorizationDataEntryField.AD_TYPE);
        return AuthorizationType.fromValue(value);
    }

    public void setAuthzType(AuthorizationType authzType) {
        this.setFieldAsInt((EnumType)AuthorizationDataEntryField.AD_TYPE, authzType.getValue());
    }

    public byte[] getAuthzData() {
        return this.getFieldAsOctets(AuthorizationDataEntryField.AD_DATA);
    }

    public void setAuthzData(byte[] authzData) {
        this.setFieldAsOctets(AuthorizationDataEntryField.AD_DATA, authzData);
    }

    public <T extends Asn1Type> T getAuthzDataAs(Class<T> type) {
        Asn1Type result = null;
        byte[] authzBytes = this.getFieldAsOctets(AuthorizationDataEntryField.AD_DATA);
        if (authzBytes != null) {
            try {
                result = (Asn1Type)type.newInstance();
                result.decode(authzBytes);
            }
            catch (IOException | IllegalAccessException | InstantiationException e) {
                LOG.error("Failed to get the AD_DATA field. " + e.toString());
            }
        }
        return (T)result;
    }

    public AuthorizationDataEntry clone() {
        return new AuthorizationDataEntry(this.getAuthzType(), (byte[])this.getAuthzData().clone());
    }

    protected static enum AuthorizationDataEntryField implements EnumType
    {
        AD_TYPE,
        AD_DATA;


        @Override
        public int getValue() {
            return this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

