/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import io.prestosql.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.prestosql.hadoop.$internal.com.google.protobuf.RpcController;
import io.prestosql.hadoop.$internal.com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsServerProtos;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class DatanodeProtocolClientSideTranslatorPB
implements ProtocolMetaInterface,
DatanodeProtocol,
Closeable {
    private final DatanodeProtocolPB rpcProxy;
    private static final HdfsServerProtos.VersionRequestProto VOID_VERSION_REQUEST = HdfsServerProtos.VersionRequestProto.newBuilder().build();
    private static final RpcController NULL_CONTROLLER = null;

    @VisibleForTesting
    public DatanodeProtocolClientSideTranslatorPB(DatanodeProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    public DatanodeProtocolClientSideTranslatorPB(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        RPC.setProtocolEngine(conf, DatanodeProtocolPB.class, ProtobufRpcEngine.class);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.rpcProxy = DatanodeProtocolClientSideTranslatorPB.createNamenode(nameNodeAddr, conf, ugi);
    }

    private static DatanodeProtocolPB createNamenode(InetSocketAddress nameNodeAddr, Configuration conf, UserGroupInformation ugi) throws IOException {
        return RPC.getProxy(DatanodeProtocolPB.class, RPC.getProtocolVersion(DatanodeProtocolPB.class), nameNodeAddr, ugi, conf, NetUtils.getSocketFactory(conf, DatanodeProtocolPB.class));
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public DatanodeRegistration registerDatanode(DatanodeRegistration registration) throws IOException {
        DatanodeProtocolProtos.RegisterDatanodeResponseProto resp;
        DatanodeProtocolProtos.RegisterDatanodeRequestProto.Builder builder = DatanodeProtocolProtos.RegisterDatanodeRequestProto.newBuilder().setRegistration(PBHelper.convert(registration));
        try {
            resp = this.rpcProxy.registerDatanode(NULL_CONTROLLER, builder.build());
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException(se);
        }
        return PBHelper.convert(resp.getRegistration());
    }

    @Override
    public HeartbeatResponse sendHeartbeat(DatanodeRegistration registration, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xmitsInProgress, int xceiverCount, int failedVolumes, VolumeFailureSummary volumeFailureSummary, boolean requestFullBlockReportLease, @Nonnull SlowPeerReports slowPeers, @Nonnull SlowDiskReports slowDisks) throws IOException {
        DatanodeProtocolProtos.HeartbeatResponseProto resp;
        DatanodeProtocolProtos.HeartbeatRequestProto.Builder builder = DatanodeProtocolProtos.HeartbeatRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).setXmitsInProgress(xmitsInProgress).setXceiverCount(xceiverCount).setFailedVolumes(failedVolumes).setRequestFullBlockReportLease(requestFullBlockReportLease);
        builder.addAllReports(PBHelperClient.convertStorageReports(reports));
        if (cacheCapacity != 0L) {
            builder.setCacheCapacity(cacheCapacity);
        }
        if (cacheUsed != 0L) {
            builder.setCacheUsed(cacheUsed);
        }
        if (volumeFailureSummary != null) {
            builder.setVolumeFailureSummary(PBHelper.convertVolumeFailureSummary(volumeFailureSummary));
        }
        if (slowPeers.haveSlowPeers()) {
            builder.addAllSlowPeers(PBHelper.convertSlowPeerInfo(slowPeers));
        }
        if (slowDisks.haveSlowDisks()) {
            builder.addAllSlowDisks(PBHelper.convertSlowDiskInfo(slowDisks));
        }
        try {
            resp = this.rpcProxy.sendHeartbeat(NULL_CONTROLLER, builder.build());
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException(se);
        }
        DatanodeCommand[] cmds = new DatanodeCommand[resp.getCmdsList().size()];
        int index = 0;
        for (DatanodeProtocolProtos.DatanodeCommandProto p : resp.getCmdsList()) {
            cmds[index] = PBHelper.convert(p);
            ++index;
        }
        RollingUpgradeStatus rollingUpdateStatus = null;
        if (resp.hasRollingUpgradeStatusV2()) {
            rollingUpdateStatus = PBHelperClient.convert(resp.getRollingUpgradeStatusV2());
        } else if (resp.hasRollingUpgradeStatus()) {
            rollingUpdateStatus = PBHelperClient.convert(resp.getRollingUpgradeStatus());
        }
        return new HeartbeatResponse(cmds, PBHelper.convert(resp.getHaStatus()), rollingUpdateStatus, resp.getFullBlockReportLeaseId());
    }

    @Override
    public DatanodeCommand blockReport(DatanodeRegistration registration, String poolId, StorageBlockReport[] reports, BlockReportContext context) throws IOException {
        DatanodeProtocolProtos.BlockReportResponseProto resp;
        DatanodeProtocolProtos.BlockReportRequestProto.Builder builder = DatanodeProtocolProtos.BlockReportRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).setBlockPoolId(poolId);
        boolean useBlocksBuffer = registration.getNamespaceInfo().isCapabilitySupported(NamespaceInfo.Capability.STORAGE_BLOCK_REPORT_BUFFERS);
        for (StorageBlockReport r : reports) {
            DatanodeProtocolProtos.StorageBlockReportProto.Builder reportBuilder = DatanodeProtocolProtos.StorageBlockReportProto.newBuilder().setStorage(PBHelperClient.convert(r.getStorage()));
            BlockListAsLongs blocks = r.getBlocks();
            if (useBlocksBuffer) {
                reportBuilder.setNumberOfBlocks(blocks.getNumberOfBlocks());
                reportBuilder.addAllBlocksBuffers(blocks.getBlocksBuffers());
            } else {
                for (long value : blocks.getBlockListAsLongs()) {
                    reportBuilder.addBlocks(value);
                }
            }
            builder.addReports(reportBuilder.build());
        }
        builder.setContext(PBHelper.convert(context));
        try {
            resp = this.rpcProxy.blockReport(NULL_CONTROLLER, builder.build());
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException(se);
        }
        return resp.hasCmd() ? PBHelper.convert(resp.getCmd()) : null;
    }

    @Override
    public DatanodeCommand cacheReport(DatanodeRegistration registration, String poolId, List<Long> blockIds) throws IOException {
        DatanodeProtocolProtos.CacheReportResponseProto resp;
        DatanodeProtocolProtos.CacheReportRequestProto.Builder builder = DatanodeProtocolProtos.CacheReportRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).setBlockPoolId(poolId);
        for (Long blockId : blockIds) {
            builder.addBlocks(blockId);
        }
        try {
            resp = this.rpcProxy.cacheReport(NULL_CONTROLLER, builder.build());
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException(se);
        }
        if (resp.hasCmd()) {
            return PBHelper.convert(resp.getCmd());
        }
        return null;
    }

    @Override
    public void blockReceivedAndDeleted(DatanodeRegistration registration, String poolId, StorageReceivedDeletedBlocks[] receivedAndDeletedBlocks) throws IOException {
        DatanodeProtocolProtos.BlockReceivedAndDeletedRequestProto.Builder builder = DatanodeProtocolProtos.BlockReceivedAndDeletedRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).setBlockPoolId(poolId);
        for (StorageReceivedDeletedBlocks storageBlock : receivedAndDeletedBlocks) {
            DatanodeProtocolProtos.StorageReceivedDeletedBlocksProto.Builder repBuilder = DatanodeProtocolProtos.StorageReceivedDeletedBlocksProto.newBuilder();
            repBuilder.setStorageUuid(storageBlock.getStorage().getStorageID());
            repBuilder.setStorage(PBHelperClient.convert(storageBlock.getStorage()));
            for (ReceivedDeletedBlockInfo rdBlock : storageBlock.getBlocks()) {
                repBuilder.addBlocks(PBHelper.convert(rdBlock));
            }
            builder.addBlocks(repBuilder.build());
        }
        try {
            this.rpcProxy.blockReceivedAndDeleted(NULL_CONTROLLER, builder.build());
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException(se);
        }
    }

    @Override
    public void errorReport(DatanodeRegistration registration, int errorCode, String msg) throws IOException {
        DatanodeProtocolProtos.ErrorReportRequestProto req = DatanodeProtocolProtos.ErrorReportRequestProto.newBuilder().setRegistartion(PBHelper.convert(registration)).setErrorCode(errorCode).setMsg(msg).build();
        try {
            this.rpcProxy.errorReport(NULL_CONTROLLER, req);
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException(se);
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        try {
            return PBHelper.convert(this.rpcProxy.versionRequest(NULL_CONTROLLER, VOID_VERSION_REQUEST).getInfo());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        DatanodeProtocolProtos.ReportBadBlocksRequestProto.Builder builder = DatanodeProtocolProtos.ReportBadBlocksRequestProto.newBuilder();
        for (int i = 0; i < blocks.length; ++i) {
            builder.addBlocks(i, PBHelperClient.convertLocatedBlock(blocks[i]));
        }
        DatanodeProtocolProtos.ReportBadBlocksRequestProto req = builder.build();
        try {
            this.rpcProxy.reportBadBlocks(NULL_CONTROLLER, req);
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException(se);
        }
    }

    @Override
    public void commitBlockSynchronization(ExtendedBlock block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException {
        DatanodeProtocolProtos.CommitBlockSynchronizationRequestProto.Builder builder = DatanodeProtocolProtos.CommitBlockSynchronizationRequestProto.newBuilder().setBlock(PBHelperClient.convert(block)).setNewGenStamp(newgenerationstamp).setNewLength(newlength).setCloseFile(closeFile).setDeleteBlock(deleteblock);
        for (int i = 0; i < newtargets.length; ++i) {
            builder.addNewTaragets(PBHelperClient.convert(newtargets[i]));
            builder.addNewTargetStorages(newtargetstorages[i]);
        }
        DatanodeProtocolProtos.CommitBlockSynchronizationRequestProto req = builder.build();
        try {
            this.rpcProxy.commitBlockSynchronization(NULL_CONTROLLER, req);
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException(se);
        }
    }

    @Override
    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported(this.rpcProxy, DatanodeProtocolPB.class, RPC.RpcKind.RPC_PROTOCOL_BUFFER, RPC.getProtocolVersion(DatanodeProtocolPB.class), methodName);
    }
}

