/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.ReplicaUnderConstruction;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public abstract class BlockInfo
extends Block
implements LightWeightGSet.LinkedElement {
    public static final BlockInfo[] EMPTY_ARRAY = new BlockInfo[0];
    private short replication;
    private volatile long bcId;
    private LightWeightGSet.LinkedElement nextLinkedElement;
    protected DatanodeStorageInfo[] storages;
    private BlockUnderConstructionFeature uc;

    public BlockInfo(short size) {
        this.storages = new DatanodeStorageInfo[size];
        this.bcId = -1L;
        this.replication = this.isStriped() ? (short)0 : size;
    }

    public BlockInfo(Block blk, short size) {
        super(blk);
        this.storages = new DatanodeStorageInfo[size];
        this.bcId = -1L;
        this.replication = this.isStriped() ? (short)0 : size;
    }

    public short getReplication() {
        return this.replication;
    }

    public void setReplication(short repl) {
        this.replication = repl;
    }

    public long getBlockCollectionId() {
        return this.bcId;
    }

    public void setBlockCollectionId(long id) {
        this.bcId = id;
    }

    public void delete() {
        this.setBlockCollectionId(-1L);
    }

    public boolean isDeleted() {
        return this.bcId == -1L;
    }

    public Iterator<DatanodeStorageInfo> getStorageInfos() {
        return new Iterator<DatanodeStorageInfo>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < BlockInfo.this.storages.length && BlockInfo.this.storages[this.index] == null) {
                    ++this.index;
                }
                return this.index < BlockInfo.this.storages.length;
            }

            @Override
            public DatanodeStorageInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return BlockInfo.this.storages[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Sorry. can't remove.");
            }
        };
    }

    public DatanodeDescriptor getDatanode(int index) {
        DatanodeStorageInfo storage = this.getStorageInfo(index);
        return storage == null ? null : storage.getDatanodeDescriptor();
    }

    DatanodeStorageInfo getStorageInfo(int index) {
        assert (this.storages != null) : "BlockInfo is not initialized";
        return this.storages[index];
    }

    void setStorageInfo(int index, DatanodeStorageInfo storage) {
        assert (this.storages != null) : "BlockInfo is not initialized";
        this.storages[index] = storage;
    }

    public int getCapacity() {
        assert (this.storages != null) : "BlockInfo is not initialized";
        return this.storages.length;
    }

    public abstract int numNodes();

    abstract boolean addStorage(DatanodeStorageInfo var1, Block var2);

    abstract boolean removeStorage(DatanodeStorageInfo var1);

    public abstract boolean isStriped();

    public abstract BlockType getBlockType();

    abstract boolean hasNoStorage();

    DatanodeStorageInfo findStorageInfo(DatanodeDescriptor dn) {
        int len = this.getCapacity();
        DatanodeStorageInfo providedStorageInfo = null;
        for (int idx = 0; idx < len; ++idx) {
            DatanodeStorageInfo cur = this.getStorageInfo(idx);
            if (cur == null) continue;
            if (cur.getStorageType() == StorageType.PROVIDED) {
                if (dn.getStorageInfo(cur.getStorageID()) == null) continue;
                providedStorageInfo = cur;
                continue;
            }
            if (cur.getDatanodeDescriptor() != dn) continue;
            return cur;
        }
        return providedStorageInfo;
    }

    int findStorageInfo(DatanodeStorageInfo storageInfo) {
        int len = this.getCapacity();
        for (int idx = 0; idx < len; ++idx) {
            DatanodeStorageInfo cur = this.getStorageInfo(idx);
            if (cur != storageInfo) continue;
            return idx;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    @Override
    public LightWeightGSet.LinkedElement getNext() {
        return this.nextLinkedElement;
    }

    @Override
    public void setNext(LightWeightGSet.LinkedElement next) {
        this.nextLinkedElement = next;
    }

    public BlockUnderConstructionFeature getUnderConstructionFeature() {
        return this.uc;
    }

    public HdfsServerConstants.BlockUCState getBlockUCState() {
        return this.uc == null ? HdfsServerConstants.BlockUCState.COMPLETE : this.uc.getBlockUCState();
    }

    public boolean isComplete() {
        return this.getBlockUCState().equals((Object)HdfsServerConstants.BlockUCState.COMPLETE);
    }

    public boolean isUnderRecovery() {
        return this.getBlockUCState().equals((Object)HdfsServerConstants.BlockUCState.UNDER_RECOVERY);
    }

    public final boolean isCompleteOrCommitted() {
        HdfsServerConstants.BlockUCState state = this.getBlockUCState();
        return state.equals((Object)HdfsServerConstants.BlockUCState.COMPLETE) || state.equals((Object)HdfsServerConstants.BlockUCState.COMMITTED);
    }

    public void convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState s, DatanodeStorageInfo[] targets) {
        if (this.isComplete()) {
            this.uc = new BlockUnderConstructionFeature(this, s, targets, this.getBlockType());
        } else {
            this.uc.setBlockUCState(s);
            this.uc.setExpectedLocations(this, targets, this.getBlockType());
        }
    }

    void convertToCompleteBlock() {
        assert (this.getBlockUCState() != HdfsServerConstants.BlockUCState.COMPLETE) : "Trying to convert a COMPLETE block";
        this.uc = null;
    }

    public List<ReplicaUnderConstruction> setGenerationStampAndVerifyReplicas(long genStamp) {
        Preconditions.checkState(this.uc != null && !this.isComplete());
        this.setGenerationStamp(genStamp);
        return this.uc.getStaleReplicas(genStamp);
    }

    List<ReplicaUnderConstruction> commitBlock(Block block) throws IOException {
        if (this.getBlockId() != block.getBlockId()) {
            throw new IOException("Trying to commit inconsistent block: id = " + block.getBlockId() + ", expected id = " + this.getBlockId());
        }
        Preconditions.checkState(!this.isComplete());
        this.uc.commit();
        this.setNumBytes(block.getNumBytes());
        return this.setGenerationStampAndVerifyReplicas(block.getGenerationStamp());
    }
}

