/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.reader;

import io.prestosql.parquet.ParquetTypeUtils;
import io.prestosql.parquet.RichColumnDescriptor;
import io.prestosql.parquet.reader.PrimitiveColumnReader;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import org.apache.parquet.schema.PrimitiveType;

public class ShortDecimalColumnReader
extends PrimitiveColumnReader {
    ShortDecimalColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            long decimalValue = this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT32) ? (long)this.valuesReader.readInteger() : (this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT64) ? this.valuesReader.readLong() : ParquetTypeUtils.getShortDecimalValue(this.valuesReader.readBytes().getBytes()));
            type.writeLong(blockBuilder, decimalValue);
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            if (this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT32)) {
                this.valuesReader.readInteger();
            } else if (this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT64)) {
                this.valuesReader.readLong();
            } else {
                this.valuesReader.readBytes();
            }
        }
    }
}

