/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFilesTable;
import org.apache.iceberg.HistoryTable;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SnapshotsTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;

public abstract class BaseMetastoreCatalog
implements Catalog {
    private final Configuration conf;

    protected BaseMetastoreCatalog(Configuration conf) {
        this.conf = conf;
    }

    public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        TableOperations ops = this.newTableOps(this.conf, identifier);
        if (ops.current() != null) {
            throw new AlreadyExistsException("Table already exists: " + identifier, new Object[0]);
        }
        String baseLocation = location != null ? location : this.defaultWarehouseLocation(this.conf, identifier);
        TableMetadata metadata = TableMetadata.newTableMetadata(ops, schema, spec, baseLocation, (Map<String, String>)(properties == null ? Maps.newHashMap() : properties));
        ops.commit(null, metadata);
        try {
            return new BaseTable(ops, identifier.toString());
        }
        catch (CommitFailedException ignored) {
            throw new AlreadyExistsException("Table was created concurrently: " + identifier, new Object[0]);
        }
    }

    public Table loadTable(TableIdentifier identifier) {
        TableOperations ops = this.newTableOps(this.conf, identifier);
        if (ops.current() == null) {
            String name = identifier.name();
            TableType type = TableType.from(name);
            if (type != null) {
                return this.loadMetadataTable(TableIdentifier.of((String[])identifier.namespace().levels()), type);
            }
            throw new NoSuchTableException("Table does not exist: " + identifier, new Object[0]);
        }
        return new BaseTable(ops, identifier.toString());
    }

    private Table loadMetadataTable(TableIdentifier identifier, TableType type) {
        TableOperations ops = this.newTableOps(this.conf, identifier);
        if (ops.current() == null) {
            throw new NoSuchTableException("Table does not exist: " + identifier, new Object[0]);
        }
        BaseTable baseTable = new BaseTable(ops, identifier.toString());
        switch (type) {
            case ENTRIES: {
                return new ManifestEntriesTable(ops, baseTable);
            }
            case FILES: {
                return new DataFilesTable(ops, baseTable);
            }
            case HISTORY: {
                return new HistoryTable(ops, baseTable);
            }
            case SNAPSHOTS: {
                return new SnapshotsTable(ops, baseTable);
            }
            case MANIFESTS: {
                return new ManifestsTable(ops, baseTable);
            }
        }
        throw new NoSuchTableException(String.format("Unknown metadata table type: %s for %s", new Object[]{type, identifier}), new Object[0]);
    }

    protected abstract TableOperations newTableOps(Configuration var1, TableIdentifier var2);

    protected abstract String defaultWarehouseLocation(Configuration var1, TableIdentifier var2);

    static enum TableType {
        ENTRIES,
        FILES,
        HISTORY,
        SNAPSHOTS,
        MANIFESTS;


        static TableType from(String name) {
            try {
                return TableType.valueOf(name.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
    }
}

