/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetastoreTableOperations
implements TableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMetastoreTableOperations.class);
    public static final String TABLE_TYPE_PROP = "table_type";
    public static final String ICEBERG_TABLE_TYPE_VALUE = "iceberg";
    public static final String METADATA_LOCATION_PROP = "metadata_location";
    public static final String PREVIOUS_METADATA_LOCATION_PROP = "previous_metadata_location";
    private static final String METADATA_FOLDER_NAME = "metadata";
    private static final String DATA_FOLDER_NAME = "data";
    private final Configuration conf;
    private final FileIO fileIo;
    private TableMetadata currentMetadata = null;
    private String currentMetadataLocation = null;
    private boolean shouldRefresh = true;
    private int version = -1;

    protected BaseMetastoreTableOperations(Configuration conf) {
        this.conf = conf;
        this.fileIo = new HadoopFileIO(conf);
    }

    @Override
    public TableMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh();
        }
        return this.currentMetadata;
    }

    public String currentMetadataLocation() {
        return this.currentMetadataLocation;
    }

    public int currentVersion() {
        return this.version;
    }

    protected void requestRefresh() {
        this.shouldRefresh = true;
    }

    protected String writeNewMetadata(TableMetadata metadata, int newVersion) {
        String newTableMetadataFilePath = this.newTableMetadataFilePath(metadata, newVersion);
        OutputFile newMetadataLocation = this.fileIo.newOutputFile(newTableMetadataFilePath);
        TableMetadataParser.write(metadata, newMetadataLocation);
        return newTableMetadataFilePath;
    }

    protected void refreshFromMetadataLocation(String newLocation) {
        this.refreshFromMetadataLocation(newLocation, 20);
    }

    protected void refreshFromMetadataLocation(String newLocation, int numRetries) {
        if (!Objects.equal((Object)this.currentMetadataLocation, (Object)newLocation)) {
            LOG.info("Refreshing table metadata from new version: {}", (Object)newLocation);
            AtomicReference newMetadata = new AtomicReference();
            Tasks.foreach(newLocation).retry(numRetries).exponentialBackoff(100L, 5000L, 600000L, 4.0).suppressFailureWhenFinished().run(metadataLocation -> newMetadata.set(TableMetadataParser.read(this, this.io().newInputFile(metadataLocation))));
            String newUUID = ((TableMetadata)newMetadata.get()).uuid();
            if (this.currentMetadata != null) {
                Preconditions.checkState((newUUID == null || newUUID.equals(this.currentMetadata.uuid()) ? 1 : 0) != 0, (String)"Table UUID does not match: current=%s != refreshed=%s", (Object)this.currentMetadata.uuid(), (Object)newUUID);
            }
            this.currentMetadata = (TableMetadata)newMetadata.get();
            this.currentMetadataLocation = newLocation;
            this.version = BaseMetastoreTableOperations.parseVersion(newLocation);
        }
        this.shouldRefresh = false;
    }

    private String metadataFileLocation(TableMetadata metadata, String filename) {
        String metadataLocation = metadata.properties().get("write.metadata.path");
        if (metadataLocation != null) {
            return String.format("%s/%s", metadataLocation, filename);
        }
        return String.format("%s/%s/%s", metadata.location(), METADATA_FOLDER_NAME, filename);
    }

    @Override
    public String metadataFileLocation(String filename) {
        return this.metadataFileLocation(this.current(), filename);
    }

    @Override
    public FileIO io() {
        return this.fileIo;
    }

    @Override
    public LocationProvider locationProvider() {
        return LocationProviders.locationsFor(this.current().location(), this.current().properties());
    }

    private String newTableMetadataFilePath(TableMetadata meta, int newVersion) {
        String codecName = meta.property("write.metadata.compression-codec", "none");
        String fileExtension = TableMetadataParser.getFileExtension(codecName);
        return this.metadataFileLocation(meta, String.format("%05d-%s%s", newVersion, UUID.randomUUID(), fileExtension));
    }

    private static int parseVersion(String metadataLocation) {
        int versionStart = metadataLocation.lastIndexOf(47) + 1;
        int versionEnd = metadataLocation.indexOf(45, versionStart);
        try {
            return Integer.valueOf(metadataLocation.substring(versionStart, versionEnd));
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to parse version from metadata location: {}", (Object)metadataLocation, (Object)e);
            return -1;
        }
    }
}

