/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericPartitionFieldSummary;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.InputFile;

class BaseSnapshot
implements Snapshot {
    private final TableOperations ops;
    private final long snapshotId;
    private final Long parentId;
    private final long timestampMillis;
    private final InputFile manifestList;
    private final String operation;
    private final Map<String, String> summary;
    private List<ManifestFile> manifests = null;
    private List<DataFile> cachedAdds = null;
    private List<DataFile> cachedDeletes = null;

    BaseSnapshot(TableOperations ops, long snapshotId, String ... manifestFiles) {
        this(ops, snapshotId, null, System.currentTimeMillis(), null, null, Lists.transform(Arrays.asList(manifestFiles), path -> new GenericManifestFile(ops.io().newInputFile(path), 0)));
    }

    BaseSnapshot(TableOperations ops, long snapshotId, Long parentId, long timestampMillis, String operation, Map<String, String> summary, InputFile manifestList) {
        this.ops = ops;
        this.snapshotId = snapshotId;
        this.parentId = parentId;
        this.timestampMillis = timestampMillis;
        this.operation = operation;
        this.summary = summary;
        this.manifestList = manifestList;
    }

    BaseSnapshot(TableOperations ops, long snapshotId, Long parentId, long timestampMillis, String operation, Map<String, String> summary, List<ManifestFile> manifests) {
        this(ops, snapshotId, parentId, timestampMillis, operation, summary, (InputFile)null);
        this.manifests = manifests;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public Long parentId() {
        return this.parentId;
    }

    public long timestampMillis() {
        return this.timestampMillis;
    }

    public String operation() {
        return this.operation;
    }

    public Map<String, String> summary() {
        return this.summary;
    }

    public List<ManifestFile> manifests() {
        if (this.manifests == null) {
            try (AvroIterable files = Avro.read(this.manifestList).rename("manifest_file", GenericManifestFile.class.getName()).rename("partitions", GenericPartitionFieldSummary.class.getName()).rename("r508", GenericPartitionFieldSummary.class.getName()).project(ManifestFile.schema()).reuseContainers(false).build();){
                this.manifests = Lists.newLinkedList(files);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Cannot read snapshot file: %s", new Object[]{this.manifestList.location()});
            }
        }
        return this.manifests;
    }

    public List<DataFile> addedFiles() {
        if (this.cachedAdds == null) {
            this.cacheChanges();
        }
        return this.cachedAdds;
    }

    public List<DataFile> deletedFiles() {
        if (this.cachedDeletes == null) {
            this.cacheChanges();
        }
        return this.cachedDeletes;
    }

    public String manifestListLocation() {
        return this.manifestList != null ? this.manifestList.location() : null;
    }

    private void cacheChanges() {
        ArrayList adds = Lists.newArrayList();
        ArrayList deletes = Lists.newArrayList();
        for (String manifest : Iterables.transform(this.manifests(), ManifestFile::path)) {
            try {
                ManifestReader reader = ManifestReader.read(this.ops.io().newInputFile(manifest), this.ops.current()::spec);
                Throwable throwable = null;
                try {
                    for (ManifestEntry add : reader.addedFiles()) {
                        if (add.snapshotId() != this.snapshotId) continue;
                        adds.add(add.file().copyWithoutStats());
                    }
                    for (ManifestEntry delete : reader.deletedFiles()) {
                        if (delete.snapshotId() != this.snapshotId) continue;
                        deletes.add(delete.file().copyWithoutStats());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    BaseSnapshot.$closeResource(throwable, (AutoCloseable)((Object)reader));
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to close reader while caching changes", new Object[0]);
            }
        }
        this.cachedAdds = adds;
        this.cachedDeletes = deletes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.snapshotId).add("timestamp_ms", this.timestampMillis).add("operation", (Object)this.operation).add("summary", this.summary).add("manifests", this.manifests()).toString();
    }
}

