/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataTableScan;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.FastAppend;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.MergeAppend;
import org.apache.iceberg.OverwriteData;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PropertiesUpdate;
import org.apache.iceberg.RemoveSnapshots;
import org.apache.iceberg.ReplaceFiles;
import org.apache.iceberg.ReplaceManifests;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplacePartitionsOperation;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.Rollback;
import org.apache.iceberg.RollbackToSnapshot;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaUpdate;
import org.apache.iceberg.SetLocation;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StreamingDelete;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;

public class BaseTable
implements Table,
HasTableOperations {
    private final TableOperations ops;
    private final String name;

    public BaseTable(TableOperations ops, String name) {
        this.ops = ops;
        this.name = name;
    }

    @Override
    public TableOperations operations() {
        return this.ops;
    }

    public void refresh() {
        this.ops.refresh();
    }

    public TableScan newScan() {
        return new DataTableScan(this.ops, this);
    }

    public Schema schema() {
        return this.ops.current().schema();
    }

    public PartitionSpec spec() {
        return this.ops.current().spec();
    }

    public Map<String, String> properties() {
        return this.ops.current().properties();
    }

    public String location() {
        return this.ops.current().location();
    }

    public Snapshot currentSnapshot() {
        return this.ops.current().currentSnapshot();
    }

    public Snapshot snapshot(long snapshotId) {
        return this.ops.current().snapshot(snapshotId);
    }

    public Iterable<Snapshot> snapshots() {
        return this.ops.current().snapshots();
    }

    public List<HistoryEntry> history() {
        return this.ops.current().snapshotLog();
    }

    public UpdateSchema updateSchema() {
        return new SchemaUpdate(this.ops);
    }

    public UpdateProperties updateProperties() {
        return new PropertiesUpdate(this.ops);
    }

    public UpdateLocation updateLocation() {
        return new SetLocation(this.ops);
    }

    public AppendFiles newAppend() {
        return new MergeAppend(this.ops);
    }

    public AppendFiles newFastAppend() {
        return new FastAppend(this.ops);
    }

    public RewriteFiles newRewrite() {
        return new ReplaceFiles(this.ops);
    }

    public RewriteManifests rewriteManifests() {
        return new ReplaceManifests(this.ops);
    }

    public OverwriteFiles newOverwrite() {
        return new OverwriteData(this.ops);
    }

    public ReplacePartitions newReplacePartitions() {
        return new ReplacePartitionsOperation(this.ops);
    }

    public DeleteFiles newDelete() {
        return new StreamingDelete(this.ops);
    }

    public ExpireSnapshots expireSnapshots() {
        return new RemoveSnapshots(this.ops);
    }

    public Rollback rollback() {
        return new RollbackToSnapshot(this.ops);
    }

    public Transaction newTransaction() {
        return Transactions.newTransaction(this.ops);
    }

    public FileIO io() {
        return this.operations().io();
    }

    public EncryptionManager encryption() {
        return this.operations().encryption();
    }

    public LocationProvider locationProvider() {
        return this.operations().locationProvider();
    }

    public String toString() {
        return this.name;
    }
}

