/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.events.ScanEvent;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinPacking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseTableScan
implements TableScan {
    private static final Logger LOG = LoggerFactory.getLogger(TableScan.class);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final TableOperations ops;
    private final Table table;
    private final Long snapshotId;
    private final Schema schema;
    private final Expression rowFilter;
    private final boolean caseSensitive;
    private final boolean colStats;
    private final Collection<String> selectedColumns;

    protected BaseTableScan(TableOperations ops, Table table, Schema schema) {
        this(ops, table, null, schema, (Expression)Expressions.alwaysTrue(), true, false, null);
    }

    protected BaseTableScan(TableOperations ops, Table table, Long snapshotId, Schema schema, Expression rowFilter, boolean caseSensitive, boolean colStats, Collection<String> selectedColumns) {
        this.ops = ops;
        this.table = table;
        this.snapshotId = snapshotId;
        this.schema = schema;
        this.rowFilter = rowFilter;
        this.caseSensitive = caseSensitive;
        this.colStats = colStats;
        this.selectedColumns = selectedColumns;
    }

    protected abstract long targetSplitSize(TableOperations var1);

    protected abstract TableScan newRefinedScan(TableOperations var1, Table var2, Long var3, Schema var4, Expression var5, boolean var6, boolean var7, Collection<String> var8);

    protected abstract CloseableIterable<FileScanTask> planFiles(TableOperations var1, Snapshot var2, Expression var3, boolean var4, boolean var5);

    public Table table() {
        return this.table;
    }

    public TableScan useSnapshot(long scanSnapshotId) {
        Preconditions.checkArgument((this.snapshotId == null ? 1 : 0) != 0, (String)"Cannot override snapshot, already set to id=%s", (long)scanSnapshotId);
        Preconditions.checkArgument((this.ops.current().snapshot(scanSnapshotId) != null ? 1 : 0) != 0, (String)"Cannot find snapshot with ID %s", (long)scanSnapshotId);
        return this.newRefinedScan(this.ops, this.table, scanSnapshotId, this.schema, this.rowFilter, this.caseSensitive, this.colStats, this.selectedColumns);
    }

    public TableScan asOfTime(long timestampMillis) {
        Preconditions.checkArgument((this.snapshotId == null ? 1 : 0) != 0, (String)"Cannot override snapshot, already set to id=%s", (Object)this.snapshotId);
        Long lastSnapshotId = null;
        for (HistoryEntry logEntry : this.ops.current().snapshotLog()) {
            if (logEntry.timestampMillis() > timestampMillis) continue;
            lastSnapshotId = logEntry.snapshotId();
        }
        Preconditions.checkArgument((lastSnapshotId != null ? 1 : 0) != 0, (String)"Cannot find a snapshot older than %s", (Object)BaseTableScan.formatTimestampMillis(timestampMillis));
        return this.useSnapshot(lastSnapshotId);
    }

    public TableScan project(Schema projectedSchema) {
        return this.newRefinedScan(this.ops, this.table, this.snapshotId, projectedSchema, this.rowFilter, this.caseSensitive, this.colStats, this.selectedColumns);
    }

    public TableScan caseSensitive(boolean scanCaseSensitive) {
        return this.newRefinedScan(this.ops, this.table, this.snapshotId, this.schema, this.rowFilter, scanCaseSensitive, this.colStats, this.selectedColumns);
    }

    public TableScan includeColumnStats() {
        return this.newRefinedScan(this.ops, this.table, this.snapshotId, this.schema, this.rowFilter, this.caseSensitive, true, this.selectedColumns);
    }

    public TableScan select(Collection<String> columns) {
        return this.newRefinedScan(this.ops, this.table, this.snapshotId, this.schema, this.rowFilter, this.caseSensitive, this.colStats, columns);
    }

    public TableScan filter(Expression expr) {
        return this.newRefinedScan(this.ops, this.table, this.snapshotId, this.schema, Expressions.and((Expression)this.rowFilter, (Expression)expr), this.caseSensitive, this.colStats, this.selectedColumns);
    }

    public Expression filter() {
        return this.rowFilter;
    }

    public CloseableIterable<FileScanTask> planFiles() {
        Snapshot snapshot = this.snapshot();
        if (snapshot != null) {
            LOG.info("Scanning table {} snapshot {} created at {} with filter {}", new Object[]{this.table, snapshot.snapshotId(), BaseTableScan.formatTimestampMillis(snapshot.timestampMillis()), this.rowFilter});
            Listeners.notifyAll((Object)new ScanEvent(this.table.toString(), snapshot.snapshotId(), this.rowFilter, this.schema()));
            return this.planFiles(this.ops, snapshot, this.rowFilter, this.caseSensitive, this.colStats);
        }
        LOG.info("Scanning empty table {}", (Object)this.table);
        return CloseableIterable.empty();
    }

    public CloseableIterable<CombinedScanTask> planTasks() {
        long splitSize = this.targetSplitSize(this.ops);
        int lookback = this.ops.current().propertyAsInt("read.split.planning-lookback", 10);
        long openFileCost = this.ops.current().propertyAsLong("read.split.open-file-cost", 0x400000L);
        Function<FileScanTask, Long> weightFunc = file -> Math.max(file.length(), openFileCost);
        CloseableIterable<FileScanTask> splitFiles = this.splitFiles(splitSize);
        return CloseableIterable.transform((CloseableIterable)CloseableIterable.combine(new BinPacking.PackingIterable<FileScanTask>((Iterable<FileScanTask>)splitFiles, splitSize, lookback, weightFunc, true), splitFiles), BaseCombinedScanTask::new);
    }

    public Schema schema() {
        return this.lazyColumnProjection();
    }

    public Snapshot snapshot() {
        return this.snapshotId != null ? this.ops.current().snapshot(this.snapshotId) : this.ops.current().currentSnapshot();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("projection", (Object)this.schema().asStruct()).add("filter", (Object)this.rowFilter).add("caseSensitive", this.caseSensitive).toString();
    }

    private CloseableIterable<FileScanTask> splitFiles(long splitSize) {
        CloseableIterable<FileScanTask> fileScanTasks = this.planFiles();
        FluentIterable splitTasks = FluentIterable.from(fileScanTasks).transformAndConcat(input -> input.split(splitSize));
        return CloseableIterable.combine((Iterable)splitTasks, fileScanTasks);
    }

    private Schema lazyColumnProjection() {
        if (this.selectedColumns != null) {
            HashSet requiredFieldIds = Sets.newHashSet();
            requiredFieldIds.addAll(Binder.boundReferences((Types.StructType)this.table.schema().asStruct(), Collections.singletonList(this.rowFilter), (boolean)this.caseSensitive));
            Set selectedIds = this.caseSensitive ? TypeUtil.getProjectedIds((Schema)this.table.schema().select(this.selectedColumns)) : TypeUtil.getProjectedIds((Schema)this.table.schema().caseInsensitiveSelect(this.selectedColumns));
            requiredFieldIds.addAll(selectedIds);
            return TypeUtil.select((Schema)this.table.schema(), (Set)requiredFieldIds);
        }
        return this.schema;
    }

    private static String formatTimestampMillis(long millis) {
        return DATE_FORMAT.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault()));
    }
}

