/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.FastAppend;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.MergeAppend;
import org.apache.iceberg.OverwriteData;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PendingUpdate;
import org.apache.iceberg.PropertiesUpdate;
import org.apache.iceberg.RemoveSnapshots;
import org.apache.iceberg.ReplaceFiles;
import org.apache.iceberg.ReplaceManifests;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplacePartitionsOperation;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.Rollback;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaUpdate;
import org.apache.iceberg.SetLocation;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StreamingDelete;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.util.Tasks;

class BaseTransaction
implements Transaction {
    private final TableOperations ops;
    private final TransactionTable transactionTable;
    private final TableOperations transactionOps;
    private final List<PendingUpdate> updates;
    private final Set<Long> intermediateSnapshotIds;
    private final Set<String> deletedFiles = Sets.newHashSet();
    private final Consumer<String> enqueueDelete = this.deletedFiles::add;
    private TransactionType type;
    private TableMetadata base;
    private TableMetadata lastBase;
    private TableMetadata current;

    BaseTransaction(TableOperations ops, TableMetadata start) {
        this.ops = ops;
        this.transactionTable = new TransactionTable();
        this.transactionOps = new TransactionTableOperations();
        this.updates = Lists.newArrayList();
        this.intermediateSnapshotIds = Sets.newHashSet();
        this.base = ops.current();
        this.type = this.base == null && start != null ? TransactionType.CREATE_TABLE : (this.base != null && start != this.base ? TransactionType.REPLACE_TABLE : TransactionType.SIMPLE);
        this.lastBase = null;
        this.current = start;
    }

    public Table table() {
        return this.transactionTable;
    }

    private void checkLastOperationCommitted(String operation) {
        Preconditions.checkState((this.lastBase != this.current ? 1 : 0) != 0, (String)"Cannot create new %s: last operation has not committed", (Object)operation);
        this.lastBase = this.current;
    }

    public UpdateSchema updateSchema() {
        this.checkLastOperationCommitted("UpdateSchema");
        SchemaUpdate schemaChange = new SchemaUpdate(this.transactionOps);
        this.updates.add((PendingUpdate)schemaChange);
        return schemaChange;
    }

    public UpdateProperties updateProperties() {
        this.checkLastOperationCommitted("UpdateProperties");
        PropertiesUpdate props = new PropertiesUpdate(this.transactionOps);
        this.updates.add((PendingUpdate)props);
        return props;
    }

    public UpdateLocation updateLocation() {
        this.checkLastOperationCommitted("UpdateLocation");
        SetLocation setLocation = new SetLocation(this.transactionOps);
        this.updates.add((PendingUpdate)setLocation);
        return setLocation;
    }

    public AppendFiles newAppend() {
        this.checkLastOperationCommitted("AppendFiles");
        MergeAppend append = new MergeAppend(this.transactionOps);
        append.deleteWith(this.enqueueDelete);
        this.updates.add((PendingUpdate)append);
        return append;
    }

    public AppendFiles newFastAppend() {
        this.checkLastOperationCommitted("AppendFiles");
        FastAppend append = new FastAppend(this.transactionOps);
        this.updates.add((PendingUpdate)append);
        return append;
    }

    public RewriteFiles newRewrite() {
        this.checkLastOperationCommitted("RewriteFiles");
        ReplaceFiles rewrite = new ReplaceFiles(this.transactionOps);
        rewrite.deleteWith(this.enqueueDelete);
        this.updates.add((PendingUpdate)rewrite);
        return rewrite;
    }

    public RewriteManifests rewriteManifests() {
        this.checkLastOperationCommitted("RewriteManifests");
        ReplaceManifests rewrite = new ReplaceManifests(this.transactionOps);
        rewrite.deleteWith(this.enqueueDelete);
        this.updates.add((PendingUpdate)rewrite);
        return rewrite;
    }

    public OverwriteFiles newOverwrite() {
        this.checkLastOperationCommitted("OverwriteFiles");
        OverwriteData overwrite = new OverwriteData(this.transactionOps);
        overwrite.deleteWith(this.enqueueDelete);
        this.updates.add((PendingUpdate)overwrite);
        return overwrite;
    }

    public ReplacePartitions newReplacePartitions() {
        this.checkLastOperationCommitted("ReplacePartitions");
        ReplacePartitionsOperation replacePartitions = new ReplacePartitionsOperation(this.transactionOps);
        replacePartitions.deleteWith(this.enqueueDelete);
        this.updates.add((PendingUpdate)replacePartitions);
        return replacePartitions;
    }

    public DeleteFiles newDelete() {
        this.checkLastOperationCommitted("DeleteFiles");
        StreamingDelete delete = new StreamingDelete(this.transactionOps);
        delete.deleteWith(this.enqueueDelete);
        this.updates.add((PendingUpdate)delete);
        return delete;
    }

    public ExpireSnapshots expireSnapshots() {
        this.checkLastOperationCommitted("ExpireSnapshots");
        RemoveSnapshots expire = new RemoveSnapshots(this.transactionOps);
        expire.deleteWith(this.enqueueDelete);
        this.updates.add((PendingUpdate)expire);
        return expire;
    }

    public void commitTransaction() {
        Preconditions.checkState((this.lastBase != this.current ? 1 : 0) != 0, (Object)"Cannot commit transaction: last operation has not committed");
        switch (this.type) {
            case CREATE_TABLE: {
                TableMetadata createMetadata = this.current.removeSnapshotLogEntries(this.intermediateSnapshotIds);
                this.ops.commit(null, createMetadata);
                break;
            }
            case REPLACE_TABLE: {
                TableMetadata replaceMetadata = this.current.removeSnapshotLogEntries(this.intermediateSnapshotIds);
                Tasks.foreach(this.ops).retry(this.base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(this.base.propertyAsInt("commit.retry.min-wait-ms", 100), this.base.propertyAsInt("commit.retry.max-wait-ms", 60000), this.base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(underlyingOps -> {
                    if (this.base != underlyingOps.refresh()) {
                        this.base = underlyingOps.current();
                    }
                    underlyingOps.commit(this.base, replaceMetadata);
                });
                break;
            }
            case SIMPLE: {
                if (this.base == this.current) {
                    return;
                }
                Tasks.foreach(this.ops).retry(this.base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(this.base.propertyAsInt("commit.retry.min-wait-ms", 100), this.base.propertyAsInt("commit.retry.max-wait-ms", 60000), this.base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(underlyingOps -> {
                    if (this.base != underlyingOps.refresh()) {
                        this.current = this.base = underlyingOps.current();
                        this.deletedFiles.clear();
                        for (PendingUpdate update : this.updates) {
                            update.commit();
                        }
                    }
                    underlyingOps.commit(this.base, this.current.removeSnapshotLogEntries(this.intermediateSnapshotIds));
                });
                this.deletedFiles.forEach(arg_0 -> ((FileIO)this.ops.io()).deleteFile(arg_0));
            }
        }
    }

    private static Long currentId(TableMetadata meta) {
        if (meta != null && meta.currentSnapshot() != null) {
            return meta.currentSnapshot().snapshotId();
        }
        return null;
    }

    @VisibleForTesting
    TableOperations ops() {
        return this.ops;
    }

    @VisibleForTesting
    Set<String> deletedFiles() {
        return this.deletedFiles;
    }

    public class TransactionTable
    implements Table {
        public void refresh() {
        }

        public TableScan newScan() {
            throw new UnsupportedOperationException("Transaction tables do not support scans");
        }

        public Schema schema() {
            return BaseTransaction.this.current.schema();
        }

        public PartitionSpec spec() {
            return BaseTransaction.this.current.spec();
        }

        public Map<String, String> properties() {
            return BaseTransaction.this.current.properties();
        }

        public String location() {
            return BaseTransaction.this.current.location();
        }

        public Snapshot currentSnapshot() {
            return BaseTransaction.this.current.currentSnapshot();
        }

        public Snapshot snapshot(long snapshotId) {
            return BaseTransaction.this.current.snapshot(snapshotId);
        }

        public Iterable<Snapshot> snapshots() {
            return BaseTransaction.this.current.snapshots();
        }

        public List<HistoryEntry> history() {
            return BaseTransaction.this.current.snapshotLog();
        }

        public UpdateSchema updateSchema() {
            return BaseTransaction.this.updateSchema();
        }

        public UpdateProperties updateProperties() {
            return BaseTransaction.this.updateProperties();
        }

        public UpdateLocation updateLocation() {
            return BaseTransaction.this.updateLocation();
        }

        public AppendFiles newAppend() {
            return BaseTransaction.this.newAppend();
        }

        public AppendFiles newFastAppend() {
            return BaseTransaction.this.newFastAppend();
        }

        public RewriteFiles newRewrite() {
            return BaseTransaction.this.newRewrite();
        }

        public RewriteManifests rewriteManifests() {
            return BaseTransaction.this.rewriteManifests();
        }

        public OverwriteFiles newOverwrite() {
            return BaseTransaction.this.newOverwrite();
        }

        public ReplacePartitions newReplacePartitions() {
            return BaseTransaction.this.newReplacePartitions();
        }

        public DeleteFiles newDelete() {
            return BaseTransaction.this.newDelete();
        }

        public ExpireSnapshots expireSnapshots() {
            return BaseTransaction.this.expireSnapshots();
        }

        public Rollback rollback() {
            throw new UnsupportedOperationException("Transaction tables do not support rollback");
        }

        public Transaction newTransaction() {
            throw new UnsupportedOperationException("Cannot create a transaction within a transaction");
        }

        public FileIO io() {
            return BaseTransaction.this.transactionOps.io();
        }

        public EncryptionManager encryption() {
            return BaseTransaction.this.transactionOps.encryption();
        }

        public LocationProvider locationProvider() {
            return BaseTransaction.this.transactionOps.locationProvider();
        }
    }

    public class TransactionTableOperations
    implements TableOperations {
        @Override
        public TableMetadata current() {
            return BaseTransaction.this.current;
        }

        @Override
        public TableMetadata refresh() {
            return BaseTransaction.this.current;
        }

        @Override
        public void commit(TableMetadata underlyingBase, TableMetadata metadata) {
            if (underlyingBase != BaseTransaction.this.current) {
                throw new CommitFailedException("Table metadata refresh is required", new Object[0]);
            }
            Long oldId = BaseTransaction.currentId(BaseTransaction.this.current);
            if (oldId != null && !oldId.equals(BaseTransaction.currentId(metadata)) && !oldId.equals(BaseTransaction.currentId(BaseTransaction.this.base))) {
                BaseTransaction.this.intermediateSnapshotIds.add(oldId);
            }
            BaseTransaction.this.current = metadata;
        }

        @Override
        public FileIO io() {
            return BaseTransaction.this.ops.io();
        }

        @Override
        public EncryptionManager encryption() {
            return BaseTransaction.this.ops.encryption();
        }

        @Override
        public String metadataFileLocation(String fileName) {
            return BaseTransaction.this.ops.metadataFileLocation(fileName);
        }

        @Override
        public LocationProvider locationProvider() {
            return BaseTransaction.this.ops.locationProvider();
        }

        @Override
        public long newSnapshotId() {
            return BaseTransaction.this.ops.newSnapshotId();
        }
    }

    private static enum TransactionType {
        CREATE_TABLE,
        REPLACE_TABLE,
        SIMPLE;

    }
}

