/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceWrapper;

public class FileHistory {
    private static final List<String> HISTORY_COLUMNS = ImmutableList.of((Object)"file_path");

    private FileHistory() {
    }

    public static Builder table(Table table) {
        return new Builder(table);
    }

    public static class Builder {
        private final Table table;
        private final Set<CharSequenceWrapper> locations = Sets.newHashSet();
        private Long startTime = null;
        private Long endTime = null;

        public Builder(Table table) {
            this.table = table;
        }

        public Builder location(String location) {
            this.locations.add(CharSequenceWrapper.wrap(location));
            return this;
        }

        public Builder after(String timestamp) {
            Literal tsLiteral = Literal.of((CharSequence)timestamp).to((Type)Types.TimestampType.withoutZone());
            this.startTime = (Long)tsLiteral.value() / 1000L;
            return this;
        }

        public Builder after(long timestampMillis) {
            this.startTime = timestampMillis;
            return this;
        }

        public Builder before(String timestamp) {
            Literal tsLiteral = Literal.of((CharSequence)timestamp).to((Type)Types.TimestampType.withoutZone());
            this.endTime = (Long)tsLiteral.value() / 1000L;
            return this;
        }

        public Builder before(long timestampMillis) {
            this.endTime = timestampMillis;
            return this;
        }

        public Iterable<ManifestEntry> build() {
            Iterable snapshots = this.table.snapshots();
            if (this.startTime != null) {
                snapshots = Iterables.filter((Iterable)snapshots, snap -> snap.timestampMillis() >= this.startTime);
            }
            if (this.endTime != null) {
                snapshots = Iterables.filter((Iterable)snapshots, snap -> snap.timestampMillis() <= this.endTime);
            }
            HashSet matchingIds = Sets.newHashSet((Iterable)Iterables.transform((Iterable)snapshots, Snapshot::snapshotId));
            Iterable manifests = Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)snapshots, Snapshot::manifests)), manifest -> manifest.snapshotId() == null || matchingIds.contains(manifest.snapshotId()));
            ManifestGroup group = new ManifestGroup(((HasTableOperations)this.table).operations(), manifests);
            ArrayList results = Lists.newArrayList();
            try (CloseableIterable<ManifestEntry> entries = group.select(HISTORY_COLUMNS).entries();){
                CharSequenceWrapper locationWrapper = CharSequenceWrapper.wrap(null);
                for (ManifestEntry entry : entries) {
                    if (entry == null || !this.locations.contains(locationWrapper.set(entry.file().path()))) continue;
                    results.add(entry.copy());
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            return results;
        }
    }
}

