/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class ManifestsTable
extends BaseMetadataTable {
    private static final Schema SNAPSHOT_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"path", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"length", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"partition_spec_id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"added_snapshot_id", (Type)Types.LongType.get()), Types.NestedField.required((int)5, (String)"added_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)6, (String)"existing_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)7, (String)"deleted_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.required((int)8, (String)"partition_summaries", (Type)Types.ListType.ofRequired((int)9, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"contains_null", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)11, (String)"lower_bound", (Type)Types.StringType.get()), Types.NestedField.optional((int)12, (String)"upper_bound", (Type)Types.StringType.get())})))});
    private final TableOperations ops;
    private final Table table;
    private final PartitionSpec spec;

    ManifestsTable(TableOperations ops, Table table) {
        this.ops = ops;
        this.table = table;
        this.spec = table.spec();
    }

    @Override
    Table table() {
        return this.table;
    }

    @Override
    String metadataTableName() {
        return "manifests";
    }

    public TableScan newScan() {
        return new SnapshotsTableScan();
    }

    public String location() {
        return this.ops.current().file().location();
    }

    public Schema schema() {
        return SNAPSHOT_SCHEMA;
    }

    protected DataTask task(TableScan scan) {
        return StaticDataTask.of(this.ops.io().newInputFile(scan.snapshot().manifestListLocation()), scan.snapshot().manifests(), this::manifestFileToRow);
    }

    private StaticDataTask.Row manifestFileToRow(ManifestFile manifest) {
        return StaticDataTask.Row.of(manifest.path(), manifest.length(), manifest.partitionSpecId(), manifest.snapshotId(), manifest.addedFilesCount(), manifest.existingFilesCount(), manifest.deletedFilesCount(), this.partitionSummariesToRows(manifest.partitions()));
    }

    private List<StaticDataTask.Row> partitionSummariesToRows(List<ManifestFile.PartitionFieldSummary> summaries) {
        ArrayList rows = Lists.newArrayList();
        for (int i = 0; i < this.spec.fields().size(); ++i) {
            ManifestFile.PartitionFieldSummary summary = summaries.get(i);
            rows.add(StaticDataTask.Row.of(summary.containsNull(), ((PartitionField)this.spec.fields().get(i)).transform().toHumanString(Conversions.fromByteBuffer((Type)((Types.NestedField)this.spec.partitionType().fields().get(i)).type(), (ByteBuffer)summary.lowerBound())), ((PartitionField)this.spec.fields().get(i)).transform().toHumanString(Conversions.fromByteBuffer((Type)((Types.NestedField)this.spec.partitionType().fields().get(i)).type(), (ByteBuffer)summary.upperBound()))));
        }
        return rows;
    }

    private class SnapshotsTableScan
    extends StaticTableScan {
        SnapshotsTableScan() {
            super(ManifestsTable.this.ops, ManifestsTable.this.table, SNAPSHOT_SCHEMA, ManifestsTable.this::task);
        }
    }
}

