/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.iceberg.MetricsModes;

public class MetricsConfig {
    private static final String COLUMN_CONF_PREFIX = "write.metadata.metrics.column.";
    private Map<String, MetricsModes.MetricsMode> columnModes = Maps.newHashMap();
    private MetricsModes.MetricsMode defaultMode;

    private MetricsConfig() {
    }

    public static MetricsConfig getDefault() {
        MetricsConfig spec = new MetricsConfig();
        spec.defaultMode = MetricsModes.fromString("truncate(16)");
        return spec;
    }

    public static MetricsConfig fromProperties(Map<String, String> props) {
        MetricsConfig spec = new MetricsConfig();
        props.keySet().stream().filter(key -> key.startsWith(COLUMN_CONF_PREFIX)).forEach(key -> {
            MetricsModes.MetricsMode mode = MetricsModes.fromString((String)props.get(key));
            String columnAlias = key.replaceFirst(COLUMN_CONF_PREFIX, "");
            spec.columnModes.put(columnAlias, mode);
        });
        String defaultModeAsString = props.getOrDefault("write.metadata.metrics.default", "truncate(16)");
        spec.defaultMode = MetricsModes.fromString(defaultModeAsString);
        return spec;
    }

    public MetricsModes.MetricsMode columnMode(String columnAlias) {
        return this.columnModes.getOrDefault(columnAlias, this.defaultMode);
    }
}

