/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;

public class OverwriteData
extends MergingSnapshotProducer<OverwriteFiles>
implements OverwriteFiles {
    private boolean validateAddedFiles = false;

    protected OverwriteData(TableOperations ops) {
        super(ops);
    }

    @Override
    protected OverwriteFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "overwrite";
    }

    public OverwriteFiles overwriteByRowFilter(Expression expr) {
        this.deleteByRowFilter(expr);
        return this;
    }

    public OverwriteFiles addFile(DataFile file) {
        this.add(file);
        return this;
    }

    public OverwriteFiles validateAddedFiles() {
        this.validateAddedFiles = true;
        return this;
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base) {
        if (this.validateAddedFiles) {
            PartitionSpec spec = this.writeSpec();
            Expression rowFilter = this.rowFilter();
            Expression inclusiveExpr = Projections.inclusive((PartitionSpec)spec).project(rowFilter);
            Evaluator inclusive = new Evaluator(spec.partitionType(), inclusiveExpr);
            Expression strictExpr = Projections.strict((PartitionSpec)spec).project(rowFilter);
            Evaluator strict = new Evaluator(spec.partitionType(), strictExpr);
            StrictMetricsEvaluator metrics = new StrictMetricsEvaluator(base.schema(), rowFilter);
            for (DataFile file : this.addedFiles()) {
                ValidationException.check((inclusive.eval(file.partition()) && (strict.eval(file.partition()) || metrics.eval(file)) ? 1 : 0) != 0, (String)"Cannot append file with rows that do not match filter: %s: %s", (Object[])new Object[]{rowFilter, file.path()});
            }
        }
        return super.apply(base);
    }
}

