/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.util.internal.ConcurrentSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoveSnapshots
implements ExpireSnapshots {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveSnapshots.class);
    private final Consumer<String> defaultDelete = new Consumer<String>(){

        @Override
        public void accept(String file) {
            RemoveSnapshots.this.ops.io().deleteFile(file);
        }
    };
    private final TableOperations ops;
    private final Set<Long> idsToRemove = Sets.newHashSet();
    private TableMetadata base;
    private Long expireOlderThan = null;
    private Consumer<String> deleteFunc = this.defaultDelete;

    RemoveSnapshots(TableOperations ops) {
        this.ops = ops;
        this.base = ops.current();
    }

    public ExpireSnapshots expireSnapshotId(long expireSnapshotId) {
        LOG.info("Expiring snapshot with id: {}", (Object)expireSnapshotId);
        this.idsToRemove.add(expireSnapshotId);
        return this;
    }

    public ExpireSnapshots expireOlderThan(long timestampMillis) {
        LOG.info("Expiring snapshots older than: {} ({})", (Object)new Date(timestampMillis), (Object)timestampMillis);
        this.expireOlderThan = timestampMillis;
        return this;
    }

    public ExpireSnapshots deleteWith(Consumer<String> newDeleteFunc) {
        this.deleteFunc = newDeleteFunc;
        return this;
    }

    public List<Snapshot> apply() {
        TableMetadata updated = this.internalApply();
        ArrayList removed = Lists.newArrayList(this.base.snapshots());
        removed.removeAll(updated.snapshots());
        return removed;
    }

    private TableMetadata internalApply() {
        this.base = this.ops.refresh();
        return this.base.removeSnapshotsIf(snapshot -> this.idsToRemove.contains(snapshot.snapshotId()) || this.expireOlderThan != null && snapshot.timestampMillis() < this.expireOlderThan);
    }

    public void commit() {
        Tasks.foreach(this.ops).retry(this.base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(this.base.propertyAsInt("commit.retry.min-wait-ms", 100), this.base.propertyAsInt("commit.retry.max-wait-ms", 60000), this.base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(item -> {
            TableMetadata updated = this.internalApply();
            if (updated.snapshots().size() != this.base.snapshots().size()) {
                this.ops.commit(this.base, updated);
            }
        });
        LOG.info("Committed snapshot changes; cleaning up expired manifests and data files.");
        TableMetadata current = this.ops.refresh();
        HashSet currentIds = Sets.newHashSet();
        HashSet currentManifests = Sets.newHashSet();
        for (Snapshot snapshot : current.snapshots()) {
            currentIds.add(snapshot.snapshotId());
            currentManifests.addAll(snapshot.manifests());
        }
        HashSet manifestListsToDelete = Sets.newHashSet();
        HashSet allManifests = Sets.newHashSet((Iterable)currentManifests);
        HashSet manifestsToDelete = Sets.newHashSet();
        for (Snapshot snapshot : this.base.snapshots()) {
            long snapshotId = snapshot.snapshotId();
            if (currentIds.contains(snapshotId)) continue;
            LOG.info("Expired snapshot: {}", (Object)snapshot);
            for (ManifestFile manifest2 : snapshot.manifests()) {
                if (currentManifests.contains(manifest2)) continue;
                manifestsToDelete.add(manifest2.path());
                allManifests.add(manifest2);
            }
            if (snapshot.manifestListLocation() == null) continue;
            manifestListsToDelete.add(snapshot.manifestListLocation());
        }
        Set<String> filesToDelete = this.getFilesToDelete(currentIds, allManifests);
        LOG.warn("Manifests to delete: {}", (Object)Joiner.on((String)", ").join((Iterable)manifestsToDelete));
        Tasks.foreach(filesToDelete).noRetry().suppressFailureWhenFinished().onFailure((file, exc) -> LOG.warn("Delete failed for data file: {}", file, (Object)exc)).run(file -> this.deleteFunc.accept((String)file));
        Tasks.foreach(manifestsToDelete).noRetry().suppressFailureWhenFinished().onFailure((manifest, exc) -> LOG.warn("Delete failed for manifest: {}", manifest, (Object)exc)).run(this.deleteFunc::accept);
        Tasks.foreach(manifestListsToDelete).noRetry().suppressFailureWhenFinished().onFailure((list, exc) -> LOG.warn("Delete failed for manifest list: {}", list, (Object)exc)).run(this.deleteFunc::accept);
    }

    private Set<String> getFilesToDelete(Set<Long> currentIds, Set<ManifestFile> allManifests) {
        ConcurrentSet filesToDelete = new ConcurrentSet();
        Tasks.foreach(allManifests).noRetry().suppressFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).onFailure((item, exc) -> LOG.warn("Failed to get deleted files: this may cause orphaned data files", (Throwable)exc)).run(arg_0 -> this.lambda$getFilesToDelete$7(currentIds, (Set)filesToDelete, arg_0));
        return filesToDelete;
    }

    private /* synthetic */ void lambda$getFilesToDelete$7(Set currentIds, Set filesToDelete, ManifestFile manifest) throws RuntimeException {
        if (manifest.deletedFilesCount() != null && manifest.deletedFilesCount() == 0) {
            return;
        }
        try (ManifestReader reader = ManifestReader.read(this.ops.io().newInputFile(manifest.path()), this.ops.current()::spec);){
            for (ManifestEntry entry : reader.entries()) {
                if (entry.status() != ManifestEntry.Status.DELETED || currentIds.contains(entry.snapshotId())) continue;
                filesToDelete.add(entry.file().path().toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to read manifest file: " + manifest.path(), new Object[0]);
        }
    }
}

