/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.TableOperations;

class ReplaceFiles
extends MergingSnapshotProducer<RewriteFiles>
implements RewriteFiles {
    ReplaceFiles(TableOperations ops) {
        super(ops);
        this.failMissingDeletePaths();
    }

    @Override
    protected RewriteFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "replace";
    }

    public RewriteFiles rewriteFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd) {
        Preconditions.checkArgument((filesToDelete != null && !filesToDelete.isEmpty() ? 1 : 0) != 0, (Object)"Files to delete cannot be null or empty");
        Preconditions.checkArgument((filesToAdd != null && !filesToAdd.isEmpty() ? 1 : 0) != 0, (Object)"Files to add can not be null or empty");
        for (DataFile toDelete : filesToDelete) {
            this.delete(toDelete.path());
        }
        for (DataFile toAdd : filesToAdd) {
            this.add(toAdd);
        }
        return this;
    }
}

