/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionSpec;

public class SnapshotSummary {
    public static final String ADDED_FILES_PROP = "added-data-files";
    public static final String DELETED_FILES_PROP = "deleted-data-files";
    public static final String TOTAL_FILES_PROP = "total-data-files";
    public static final String ADDED_RECORDS_PROP = "added-records";
    public static final String DELETED_RECORDS_PROP = "deleted-records";
    public static final String TOTAL_RECORDS_PROP = "total-records";
    public static final String DELETED_DUPLICATE_FILES = "deleted-duplicate-files";
    public static final String CHANGED_PARTITION_COUNT_PROP = "changed-partition-count";

    private SnapshotSummary() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Set<String> changedPartitions = Sets.newHashSet();
        private long addedFiles = 0L;
        private long deletedFiles = 0L;
        private long deletedDuplicateFiles = 0L;
        private long addedRecords = 0L;
        private long deletedRecords = 0L;
        private Map<String, String> properties = Maps.newHashMap();

        public void clear() {
            this.changedPartitions.clear();
            this.addedFiles = 0L;
            this.deletedFiles = 0L;
            this.deletedDuplicateFiles = 0L;
            this.addedRecords = 0L;
            this.deletedRecords = 0L;
        }

        public void incrementDuplicateDeletes() {
            ++this.deletedDuplicateFiles;
        }

        public void deletedFile(PartitionSpec spec, DataFile file) {
            this.changedPartitions.add(spec.partitionToPath(file.partition()));
            ++this.deletedFiles;
            this.deletedRecords += file.recordCount();
        }

        public void addedFile(PartitionSpec spec, DataFile file) {
            this.changedPartitions.add(spec.partitionToPath(file.partition()));
            ++this.addedFiles;
            this.addedRecords += file.recordCount();
        }

        public void set(String property, String value) {
            this.properties.put(property, value);
        }

        public Map<String, String> build() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.putAll(this.properties);
            Builder.setIf(this.addedFiles > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.ADDED_FILES_PROP, this.addedFiles);
            Builder.setIf(this.deletedFiles > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.DELETED_FILES_PROP, this.deletedFiles);
            Builder.setIf(this.deletedDuplicateFiles > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.DELETED_DUPLICATE_FILES, this.deletedDuplicateFiles);
            Builder.setIf(this.addedRecords > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.ADDED_RECORDS_PROP, this.addedRecords);
            Builder.setIf(this.deletedRecords > 0L, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.DELETED_RECORDS_PROP, this.deletedRecords);
            Builder.setIf(true, (ImmutableMap.Builder<String, String>)builder, SnapshotSummary.CHANGED_PARTITION_COUNT_PROP, this.changedPartitions.size());
            return builder.build();
        }

        private static void setIf(boolean expression, ImmutableMap.Builder<String, String> builder, String property, Object value) {
            if (expression) {
                builder.put((Object)property, (Object)String.valueOf(value));
            }
        }
    }
}

