/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.UUID;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.encryption.PlaintextEncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;

public interface TableOperations {
    public TableMetadata current();

    public TableMetadata refresh();

    public void commit(TableMetadata var1, TableMetadata var2);

    public FileIO io();

    default public EncryptionManager encryption() {
        return new PlaintextEncryptionManager();
    }

    public String metadataFileLocation(String var1);

    public LocationProvider locationProvider();

    default public long newSnapshotId() {
        UUID uuid = UUID.randomUUID();
        long mostSignificantBits = uuid.getMostSignificantBits();
        long leastSignificantBits = uuid.getLeastSignificantBits();
        return Math.abs(mostSignificantBits ^ leastSignificantBits);
    }
}

