/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avro.file.SeekableInput;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.io.DelegatingInputStream;
import org.apache.iceberg.io.SeekableInputStream;

class AvroIO {
    private static final Class<?> fsDataInputStreamClass = DynClasses.builder().impl("org.apache.hadoop.fs.FSDataInputStream").orNull().build();
    private static final boolean relocated = "org.apache.avro.file.SeekableInput".equals(SeekableInput.class.getName());
    private static final DynConstructors.Ctor<SeekableInput> avroFsInputCtor = !relocated && fsDataInputStreamClass != null ? DynConstructors.builder(SeekableInput.class).impl("org.apache.hadoop.fs.AvroFSInput", new Class[]{fsDataInputStreamClass, Long.TYPE}).build() : null;

    private AvroIO() {
    }

    static SeekableInput stream(SeekableInputStream stream, long length) {
        if (stream instanceof DelegatingInputStream) {
            InputStream wrapped = ((DelegatingInputStream)stream).getDelegate();
            if (avroFsInputCtor != null && fsDataInputStreamClass != null && fsDataInputStreamClass.isInstance(wrapped)) {
                return (SeekableInput)avroFsInputCtor.newInstance(new Object[]{wrapped, length});
            }
        }
        return new AvroInputStreamAdapter(stream, length);
    }

    private static class AvroInputStreamAdapter
    extends SeekableInputStream
    implements SeekableInput {
        private final SeekableInputStream stream;
        private final long length;

        AvroInputStreamAdapter(SeekableInputStream stream, long length) {
            this.stream = stream;
            this.length = length;
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        public void seek(long newPos) throws IOException {
            this.stream.seek(newPos);
        }

        public long tell() throws IOException {
            return this.getPos();
        }

        public long length() throws IOException {
            return this.length;
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        public int available() throws IOException {
            return this.stream.available();
        }

        public synchronized void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }
}

