/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.avro.Schema;

public abstract class AvroSchemaVisitor<T> {
    private Deque<String> recordLevels = Lists.newLinkedList();

    public static <T> T visit(Schema schema, AvroSchemaVisitor<T> visitor) {
        switch (schema.getType()) {
            case RECORD: {
                String name = schema.getFullName();
                Preconditions.checkState((!visitor.recordLevels.contains(name) ? 1 : 0) != 0, (String)"Cannot process recursive Avro record %s", (Object)name);
                visitor.recordLevels.push(name);
                List fields = schema.getFields();
                ArrayList names = Lists.newArrayListWithExpectedSize((int)fields.size());
                ArrayList results = Lists.newArrayListWithExpectedSize((int)fields.size());
                for (Schema.Field field : schema.getFields()) {
                    names.add(field.name());
                    results.add(AvroSchemaVisitor.visit(field.schema(), visitor));
                }
                visitor.recordLevels.pop();
                return visitor.record(schema, names, results);
            }
            case UNION: {
                List types = schema.getTypes();
                ArrayList options = Lists.newArrayListWithExpectedSize((int)types.size());
                for (Schema type : types) {
                    options.add(AvroSchemaVisitor.visit(type, visitor));
                }
                return visitor.union(schema, options);
            }
            case ARRAY: {
                return visitor.array(schema, AvroSchemaVisitor.visit(schema.getElementType(), visitor));
            }
            case MAP: {
                return visitor.map(schema, AvroSchemaVisitor.visit(schema.getValueType(), visitor));
            }
        }
        return visitor.primitive(schema);
    }

    public T record(Schema record, List<String> names, List<T> fields) {
        return null;
    }

    public T union(Schema union, List<T> options) {
        return null;
    }

    public T array(Schema array, T element) {
        return null;
    }

    public T map(Schema map, T value) {
        return null;
    }

    public T primitive(Schema primitive) {
        return null;
    }
}

