/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class SchemaToType
extends AvroSchemaVisitor<Type> {
    private final Schema root;
    private int nextId = 1;

    SchemaToType(Schema root) {
        this.root = root;
        if (root.getType() == Schema.Type.RECORD) {
            this.nextId = root.getFields().size();
        }
    }

    private int getElementId(Schema schema) {
        if (schema.getObjectProp("element-id") != null) {
            return AvroSchemaUtil.getElementId(schema);
        }
        return this.allocateId();
    }

    private int getKeyId(Schema schema) {
        if (schema.getObjectProp("key-id") != null) {
            return AvroSchemaUtil.getKeyId(schema);
        }
        return this.allocateId();
    }

    private int getValueId(Schema schema) {
        if (schema.getObjectProp("value-id") != null) {
            return AvroSchemaUtil.getValueId(schema);
        }
        return this.allocateId();
    }

    private int getId(Schema.Field field) {
        if (field.getObjectProp("field-id") != null) {
            return AvroSchemaUtil.getFieldId(field);
        }
        return this.allocateId();
    }

    private int allocateId() {
        int current = this.nextId++;
        return current;
    }

    @Override
    public Type record(Schema record, List<String> names, List<Type> fieldTypes) {
        List fields = record.getFields();
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fields.size());
        if (this.root == record) {
            this.nextId = 0;
        }
        for (int i = 0; i < fields.size(); ++i) {
            Schema.Field field = (Schema.Field)fields.get(i);
            Type fieldType = fieldTypes.get(i);
            int fieldId = this.getId(field);
            if (AvroSchemaUtil.isOptionSchema(field.schema())) {
                newFields.add(Types.NestedField.optional((int)fieldId, (String)field.name(), (Type)fieldType));
                continue;
            }
            newFields.add(Types.NestedField.required((int)fieldId, (String)field.name(), (Type)fieldType));
        }
        return Types.StructType.of((List)newFields);
    }

    @Override
    public Type union(Schema union, List<Type> options) {
        Preconditions.checkArgument((boolean)AvroSchemaUtil.isOptionSchema(union), (String)"Unsupported type: non-option union: %s", (Object)union);
        if (options.get(0) == null) {
            return options.get(1);
        }
        return options.get(0);
    }

    @Override
    public Type array(Schema array, Type elementType) {
        if (array.getLogicalType() instanceof LogicalMap) {
            Schema keyValueSchema = array.getElementType();
            Preconditions.checkArgument((boolean)AvroSchemaUtil.isKeyValueSchema(keyValueSchema), (String)"Invalid key-value pair schema: %s", (Object)keyValueSchema);
            Types.StructType keyValueType = elementType.asStructType();
            Types.NestedField keyField = keyValueType.field("key");
            Types.NestedField valueField = keyValueType.field("value");
            if (keyValueType.field("value").isOptional()) {
                return Types.MapType.ofOptional((int)keyField.fieldId(), (int)valueField.fieldId(), (Type)keyField.type(), (Type)valueField.type());
            }
            return Types.MapType.ofRequired((int)keyField.fieldId(), (int)valueField.fieldId(), (Type)keyField.type(), (Type)valueField.type());
        }
        Schema elementSchema = array.getElementType();
        int id = this.getElementId(array);
        if (AvroSchemaUtil.isOptionSchema(elementSchema)) {
            return Types.ListType.ofOptional((int)id, (Type)elementType);
        }
        return Types.ListType.ofRequired((int)id, (Type)elementType);
    }

    @Override
    public Type map(Schema map, Type valueType) {
        Schema valueSchema = map.getValueType();
        int keyId = this.getKeyId(map);
        int valueId = this.getValueId(map);
        if (AvroSchemaUtil.isOptionSchema(valueSchema)) {
            return Types.MapType.ofOptional((int)keyId, (int)valueId, (Type)Types.StringType.get(), (Type)valueType);
        }
        return Types.MapType.ofRequired((int)keyId, (int)valueId, (Type)Types.StringType.get(), (Type)valueType);
    }

    @Override
    public Type primitive(Schema primitive) {
        LogicalType logical = primitive.getLogicalType();
        if (logical != null) {
            String name = logical.getName();
            if (logical instanceof LogicalTypes.Decimal) {
                return Types.DecimalType.of((int)((LogicalTypes.Decimal)logical).getPrecision(), (int)((LogicalTypes.Decimal)logical).getScale());
            }
            if (logical instanceof LogicalTypes.Date) {
                return Types.DateType.get();
            }
            if (logical instanceof LogicalTypes.TimeMillis || logical instanceof LogicalTypes.TimeMicros) {
                return Types.TimeType.get();
            }
            if (logical instanceof LogicalTypes.TimestampMillis || logical instanceof LogicalTypes.TimestampMicros) {
                Object adjustToUTC = primitive.getObjectProp("adjust-to-utc");
                Preconditions.checkArgument((boolean)(adjustToUTC instanceof Boolean), (String)"Invalid value for adjust-to-utc: %s", (Object)adjustToUTC);
                if (((Boolean)adjustToUTC).booleanValue()) {
                    return Types.TimestampType.withZone();
                }
                return Types.TimestampType.withoutZone();
            }
            if (LogicalTypes.uuid().getName().equals(name)) {
                return Types.UUIDType.get();
            }
        }
        switch (primitive.getType()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case INT: {
                return Types.IntegerType.get();
            }
            case LONG: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case STRING: 
            case ENUM: {
                return Types.StringType.get();
            }
            case FIXED: {
                return Types.FixedType.ofLength((int)primitive.getFixedSize());
            }
            case BYTES: {
                return Types.BinaryType.get();
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + primitive);
    }
}

