/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopStreams;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;

public class HadoopInputFile
implements InputFile {
    private final FileSystem fs;
    private final Path path;
    private final Configuration conf;
    private FileStatus stat = null;
    private Long length = null;

    public static HadoopInputFile fromLocation(CharSequence location, Configuration conf) {
        Path path = new Path(location.toString());
        return HadoopInputFile.fromPath(path, conf);
    }

    public static HadoopInputFile fromLocation(CharSequence location, long length, Configuration conf) {
        Path path = new Path(location.toString());
        return HadoopInputFile.fromPath(path, length, conf);
    }

    public static HadoopInputFile fromPath(Path path, Configuration conf) {
        try {
            FileSystem fs = path.getFileSystem(conf);
            return new HadoopInputFile(fs, path, conf);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to get file system for path: %s", new Object[]{path});
        }
    }

    public static HadoopInputFile fromPath(Path path, long length, Configuration conf) {
        try {
            FileSystem fs = path.getFileSystem(conf);
            return new HadoopInputFile(fs, path, length, conf);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to get file system for path: %s", new Object[]{path});
        }
    }

    public static HadoopInputFile fromStatus(FileStatus stat, Configuration conf) {
        try {
            FileSystem fs = stat.getPath().getFileSystem(conf);
            return new HadoopInputFile(fs, stat, conf);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to get file system for path: %s", new Object[]{stat.getPath()});
        }
    }

    private HadoopInputFile(FileSystem fs, Path path, Configuration conf) {
        this.fs = fs;
        this.path = path;
        this.conf = conf;
    }

    private HadoopInputFile(FileSystem fs, Path path, long length, Configuration conf) {
        this.fs = fs;
        this.path = path;
        this.conf = conf;
        this.length = length;
    }

    private HadoopInputFile(FileSystem fs, FileStatus stat, Configuration conf) {
        this.fs = fs;
        this.path = stat.getPath();
        this.stat = stat;
        this.conf = conf;
        this.length = stat.getLen();
    }

    private FileStatus lazyStat() {
        if (this.stat == null) {
            try {
                this.stat = this.fs.getFileStatus(this.path);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to get status for file: %s", new Object[]{this.path});
            }
        }
        return this.stat;
    }

    public long getLength() {
        if (this.length == null) {
            this.length = this.lazyStat().getLen();
        }
        return this.length;
    }

    public SeekableInputStream newStream() {
        try {
            return HadoopStreams.wrap(this.fs.open(this.path));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to open input stream for file: %s", new Object[]{this.path});
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public FileStatus getStat() {
        return this.lazyStat();
    }

    public String location() {
        return this.path.toString();
    }

    public boolean exists() {
        try {
            return this.fs.exists(this.path);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to check existence for file: %s", new Object[]{this.path});
        }
    }

    public String toString() {
        return this.path.toString();
    }
}

