/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopStreams;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;

public class HadoopOutputFile
implements OutputFile {
    private final Path path;
    private final Configuration conf;

    public static OutputFile fromPath(Path path, Configuration conf) {
        return new HadoopOutputFile(path, conf);
    }

    private HadoopOutputFile(Path path, Configuration conf) {
        this.path = path;
        this.conf = conf;
    }

    public PositionOutputStream create() {
        FileSystem fs = Util.getFs(this.path, this.conf);
        try {
            return HadoopStreams.wrap(fs.create(this.path, false));
        }
        catch (FileAlreadyExistsException e) {
            throw new AlreadyExistsException((Throwable)e, "Path already exists: %s", new Object[]{this.path});
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create file: %s", new Object[]{this.path});
        }
    }

    public PositionOutputStream createOrOverwrite() {
        FileSystem fs = Util.getFs(this.path, this.conf);
        try {
            return HadoopStreams.wrap(fs.create(this.path, true));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create file: %s", new Object[]{this.path});
        }
    }

    public Path getPath() {
        return this.path;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String location() {
        return this.path.toString();
    }

    public InputFile toInputFile() {
        return HadoopInputFile.fromPath(this.path, this.conf);
    }

    public String toString() {
        return this.location();
    }
}

