/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Tables;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopTableOperations;

public class HadoopTables
implements Tables,
Configurable {
    private Configuration conf;

    public HadoopTables() {
        this(new Configuration());
    }

    public HadoopTables(Configuration conf) {
        this.conf = conf;
    }

    public Table load(String location) {
        TableOperations ops = this.newTableOps(location);
        if (ops.current() == null) {
            throw new NoSuchTableException("Table does not exist at location: " + location, new Object[0]);
        }
        return new BaseTable(ops, location);
    }

    public Table create(Schema schema, PartitionSpec spec, Map<String, String> properties, String location) {
        Preconditions.checkNotNull((Object)schema, (Object)"A table schema is required");
        TableOperations ops = this.newTableOps(location);
        if (ops.current() != null) {
            throw new AlreadyExistsException("Table already exists at location: " + location, new Object[0]);
        }
        Object tableProps = properties == null ? ImmutableMap.of() : properties;
        PartitionSpec partitionSpec = spec == null ? PartitionSpec.unpartitioned() : spec;
        TableMetadata metadata = TableMetadata.newTableMetadata(ops, schema, partitionSpec, location, (Map<String, String>)tableProps);
        ops.commit(null, metadata);
        return new BaseTable(ops, location);
    }

    private TableOperations newTableOps(String location) {
        return new HadoopTableOperations(new Path(location), this.conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

