/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);

    private JsonUtil() {
    }

    public static JsonFactory factory() {
        return FACTORY;
    }

    public static ObjectMapper mapper() {
        return MAPPER;
    }

    public static int getInt(String property, JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(property), (String)"Cannot parse missing int %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument((pNode != null && !pNode.isNull() && pNode.isNumber() ? 1 : 0) != 0, (String)"Cannot parse %s from non-numeric value: %s", (Object)property, (Object)pNode);
        return pNode.asInt();
    }

    public static long getLong(String property, JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(property), (String)"Cannot parse missing int %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument((pNode != null && !pNode.isNull() && pNode.isNumber() ? 1 : 0) != 0, (String)"Cannot parse %s from non-numeric value: %s", (Object)property, (Object)pNode);
        return pNode.asLong();
    }

    public static boolean getBool(String property, JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(property), (String)"Cannot parse missing boolean %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument((pNode != null && !pNode.isNull() && pNode.isBoolean() ? 1 : 0) != 0, (String)"Cannot parse %s from non-boolean value: %s", (Object)property, (Object)pNode);
        return pNode.asBoolean();
    }

    public static String getString(String property, JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(property), (String)"Cannot parse missing string %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument((pNode != null && !pNode.isNull() && pNode.isTextual() ? 1 : 0) != 0, (String)"Cannot parse %s from non-string value: %s", (Object)property, (Object)pNode);
        return pNode.asText();
    }

    public static String getStringOrNull(String property, JsonNode node) {
        if (!node.has(property)) {
            return null;
        }
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument((pNode != null && !pNode.isNull() && pNode.isTextual() ? 1 : 0) != 0, (String)"Cannot parse %s from non-string value: %s", (Object)property, (Object)pNode);
        return pNode.asText();
    }

    public static Map<String, String> getStringMap(String property, JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(property), (String)"Cannot parse missing map %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument((pNode != null && !pNode.isNull() && pNode.isObject() ? 1 : 0) != 0, (String)"Cannot parse %s from non-object value: %s", (Object)property, (Object)pNode);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterator fields = pNode.fieldNames();
        while (fields.hasNext()) {
            String field = (String)fields.next();
            builder.put((Object)field, (Object)JsonUtil.getString(field, pNode));
        }
        return builder.build();
    }

    public static List<String> getStringList(String property, JsonNode node) {
        Preconditions.checkArgument((boolean)node.has(property), (String)"Cannot parse missing list %s", (Object)property);
        JsonNode pNode = node.get(property);
        Preconditions.checkArgument((pNode != null && !pNode.isNull() && pNode.isArray() ? 1 : 0) != 0, (String)"Cannot parse %s from non-array value: %s", (Object)property, (Object)pNode);
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator elements = pNode.elements();
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            Preconditions.checkArgument((boolean)element.isTextual(), (String)"Cannot parse string from non-text value: %s", (Object)element);
            builder.add((Object)element.asText());
        }
        return builder.build();
    }
}

